/*
 * DEBUGGER code
 * 
 * On "publish", when buffer is free, debugger stores arbitrary variables 
 * content into, and mark this buffer as filled
 * 
 * 
 * Buffer content is read asynchronously, (from non real time part), 
 * and then buffer marked free again.
 *  
 * 
 * */

#include "iec_types_all.h"
#include "POUS.h"
/*for memcpy*/
#include <string.h>
#include <stdio.h>

typedef unsigned int dbgvardsc_index_t;


/***
 * Declare programs 
 **/
extern CONTROL_VSD RES0__INSTANCE0;

/***
 * Declare global variables from resources and conf 
 **/
extern __IEC_UINT_p RES0__LASTERRORCODE;
extern __IEC_BYTE_p RES0__EXPMODDISCONHISTORY;
extern __IEC_INT_p RES0__STP_SETPOINT;
extern __IEC_INT_p RES0__STP_KP;
extern __IEC_UINT_p RES0__STP_TI;
extern __IEC_UINT_p RES0__STP_TD;
extern __IEC_BOOL_p RES0__LOC_DI1;
extern __IEC_BOOL_p RES0__LOC_DI2;
extern __IEC_BOOL_p RES0__LOC_DI3;
extern __IEC_BOOL_p RES0__LOC_DI4;
extern __IEC_BOOL_p RES0__LOC_DI5;
extern __IEC_BOOL_p RES0__LOC_DI6;
extern __IEC_BOOL_p RES0__LOC_DI7;
extern __IEC_BOOL_p RES0__LOC_DI8;
extern __IEC_INT_p RES0__LOC_AI1;
extern __IEC_INT_p RES0__LOC_AI2;
extern __IEC_INT_p RES0__AI3;
extern __IEC_INT_p RES0__AI4;
extern __IEC_INT_p RES0__AI5;
extern __IEC_INT_p RES0__AI6;
extern __IEC_INT_p RES0__AI7;
extern __IEC_INT_p RES0__AI8;
extern __IEC_BOOL_p RES0__LOC_DO1;
extern __IEC_BOOL_p RES0__LOC_DO2;
extern __IEC_BOOL_p RES0__LOC_DO3;
extern __IEC_BOOL_p RES0__LOC_DO4;
extern __IEC_BOOL_p RES0__DO5;
extern __IEC_BOOL_p RES0__DO6;
extern __IEC_BOOL_p RES0__DO7;
extern __IEC_BOOL_p RES0__DO8;
extern __IEC_INT_p RES0__LOC_AO1;
extern __IEC_INT_p RES0__AO2;
extern __IEC_INT_p RES0__AO3;
extern __IEC_INT_p RES0__AO4;
extern __IEC_UDINT_p RES0__FDI1_COUNTER;
extern __IEC_UDINT_p RES0__FDI1_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI1_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI2_COUNTER;
extern __IEC_UDINT_p RES0__FDI2_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI2_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI3_COUNTER;
extern __IEC_UDINT_p RES0__FDI3_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI3_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI4_COUNTER;
extern __IEC_UDINT_p RES0__FDI4_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI4_RESET_COUNTER;
extern __IEC_BOOL_p RES0__KEY1;
extern __IEC_BOOL_p RES0__KEY2;
extern __IEC_BOOL_p RES0__KEY3;
extern __IEC_BOOL_p RES0__KEY4;
extern       CONTROL_VSD   RES0__INSTANCE0;

typedef const struct {
    void *ptr;
    __IEC_types_enum type;
} dbgvardsc_t;

const dbgvardsc_t dbgvardsc[] = {
{&(RES0__LASTERRORCODE), UINT_O_ENUM},
{&(RES0__EXPMODDISCONHISTORY), BYTE_O_ENUM},
{&(RES0__STP_SETPOINT), INT_O_ENUM},
{&(RES0__STP_KP), INT_O_ENUM},
{&(RES0__STP_TI), UINT_O_ENUM},
{&(RES0__STP_TD), UINT_O_ENUM},
{&(RES0__LOC_DI1), BOOL_P_ENUM},
{&(RES0__LOC_DI2), BOOL_P_ENUM},
{&(RES0__LOC_DI3), BOOL_P_ENUM},
{&(RES0__LOC_DI4), BOOL_P_ENUM},
{&(RES0__LOC_DI5), BOOL_P_ENUM},
{&(RES0__LOC_DI6), BOOL_P_ENUM},
{&(RES0__LOC_DI7), BOOL_P_ENUM},
{&(RES0__LOC_DI8), BOOL_P_ENUM},
{&(RES0__LOC_AI1), INT_P_ENUM},
{&(RES0__LOC_AI2), INT_P_ENUM},
{&(RES0__AI3), INT_P_ENUM},
{&(RES0__AI4), INT_P_ENUM},
{&(RES0__AI5), INT_P_ENUM},
{&(RES0__AI6), INT_P_ENUM},
{&(RES0__AI7), INT_P_ENUM},
{&(RES0__AI8), INT_P_ENUM},
{&(RES0__LOC_DO1), BOOL_O_ENUM},
{&(RES0__LOC_DO2), BOOL_O_ENUM},
{&(RES0__LOC_DO3), BOOL_O_ENUM},
{&(RES0__LOC_DO4), BOOL_O_ENUM},
{&(RES0__DO5), BOOL_O_ENUM},
{&(RES0__DO6), BOOL_O_ENUM},
{&(RES0__DO7), BOOL_O_ENUM},
{&(RES0__DO8), BOOL_O_ENUM},
{&(RES0__LOC_AO1), INT_O_ENUM},
{&(RES0__AO2), INT_O_ENUM},
{&(RES0__AO3), INT_O_ENUM},
{&(RES0__AO4), INT_O_ENUM},
{&(RES0__FDI1_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI1_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI1_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI2_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI2_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI2_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI3_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI3_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI3_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI4_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI4_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI4_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__KEY1), BOOL_O_ENUM},
{&(RES0__KEY2), BOOL_O_ENUM},
{&(RES0__KEY3), BOOL_O_ENUM},
{&(RES0__KEY4), BOOL_O_ENUM},
{&(RES0__INSTANCE0.PID1.EN), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.XEN), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.RPV), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.RSETP), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.XMANUALMODE), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.RMANUALVALUE), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.XHOLD), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.RHIGHLIMIT), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.RLOWLIMIT), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.RDEADBAND), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.XAUTOTUNE), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.RAUTOTUNEVALUE), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.RKP), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.UITI), UINT_ENUM},
{&(RES0__INSTANCE0.PID1.UITD), UINT_ENUM},
{&(RES0__INSTANCE0.PID1.XRESET), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.RANALOG), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.IANALOG), INT_ENUM},
{&(RES0__INSTANCE0.PID1.RERROR), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.UIALARMID), UINT_ENUM},
{&(RES0__INSTANCE0.PID1.UIALERTID), UINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_RDERVTERM), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RDIFFDIGITRANGE), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RDIFFOUTRANGE), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RERROLD1), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RERROLD2), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RERRSUM), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RFLTRCTHLP), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RHLFCYCLTME), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RKPOLD), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RPROPTERM), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RSPOLD), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RTD), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RTDHLP), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RTI), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_RTIHLP), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_UITIOLD), UINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_RTV), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_UDICT), UDINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_UDICTOLD), UDINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_UDIFLTRCT), UDINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_RINTTERM), REAL_ENUM},
{&(RES0__INSTANCE0.PID1.L_UDIFLTRCTOLD), UDINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_UDISUMCT), UDINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_UDITIMEINMS), UDINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_UDITIMEINMSOLD), UDINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_USICOUNT), USINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_USICOUNT1), USINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_USICOUNT2), USINT_ENUM},
{&(RES0__INSTANCE0.PID1.L_XCALCCTHOLD), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XDBND), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XDBNDOLD), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XHIGHEQLOWLIM), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XHOLDOLD), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XKPMODE), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XLIMHIGH), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XLIMLOW), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XMANOLD), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XPIDFUNCTION), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XRESETOLD), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XSPCHNG), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XSTARTCYCLETIME), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XTIMODE), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XTVTDMODE), BOOL_ENUM},
{&(RES0__INSTANCE0.PID1.L_XENOLD), BOOL_ENUM},
{&(RES0__INSTANCE0.I_MANUALMODE), BOOL_ENUM},
{&(RES0__INSTANCE0.I_MANUALVALUE), REAL_ENUM},
{&(RES0__INSTANCE0.I_HOLD), BOOL_ENUM},
{&(RES0__INSTANCE0.I_DEADBAND), REAL_ENUM},
{&(RES0__INSTANCE0.I_RESET), BOOL_ENUM},
{&(RES0__INSTANCE0.I_ANALOG), REAL_ENUM},
{&(RES0__INSTANCE0.I_ERROR), REAL_ENUM},
{&(RES0__INSTANCE0.I_ALARM), UINT_ENUM},
{&(RES0__INSTANCE0.I_ALERT), UINT_ENUM},
{&(RES0__INSTANCE0._TMP_INT_TO_REAL69_OUT), REAL_ENUM},
{&(RES0__INSTANCE0._TMP_INT_TO_REAL71_OUT), REAL_ENUM},
{&(RES0__INSTANCE0._TMP_INT_TO_REAL75_OUT), REAL_ENUM}
};
const unsigned int dbgvardsc_size = sizeof(dbgvardsc)/sizeof(dbgvardsc_t);

const dbgvardsc_index_t retain_list[] = {

};
const unsigned int retain_list_size = sizeof(retain_list)/sizeof(dbgvardsc_index_t);



void __init_debug(void)
{

}