PROGRAM Control_VSD
  VAR
    PID1 : PIDAdvanced;
    I_ManualMode : BOOL;
    I_ManualValue : REAL;
    I_Hold : BOOL;
    I_DeadBand : REAL;
    I_Reset : BOOL;
    I_Analog : REAL;
    I_Error : REAL;
    I_Alarm : UINT;
    I_Alert : UINT;
    _TMP_INT_TO_REAL69_OUT : REAL;
    _TMP_INT_TO_REAL71_OUT : REAL;
    _TMP_INT_TO_REAL75_OUT : REAL;
  END_VAR

  _TMP_INT_TO_REAL69_OUT := INT_TO_REAL(LOC_AI1);(*FBD id[69]*)
  _TMP_INT_TO_REAL71_OUT := INT_TO_REAL(STP_Setpoint);(*FBD id[71]*)
  _TMP_INT_TO_REAL75_OUT := INT_TO_REAL(STP_Kp);(*FBD id[75]*)
  PID1(xEn := TRUE, rPv := _TMP_INT_TO_REAL69_OUT, rSetp := _TMP_INT_TO_REAL71_OUT, xManualMode := I_ManualMode, rManualValue := I_ManualValue, xHold := I_Hold, rHighLimit := 100.0, rLowLimit := 0.0, rDeadband := I_DeadBand, rKp := _TMP_INT_TO_REAL75_OUT, uiTi := STP_Ti, uiTd := STP_Td, xReset := I_Reset);(*FBD id[64]*)
  I_Analog := PID1.rAnalog;(*FBD id[148]*)
  LOC_AO1 := PID1.iAnalog;(*FBD id[140]*)
  I_Error := PID1.rError;(*FBD id[149]*)
  I_Alarm := PID1.uiAlarmID;(*FBD id[150]*)
  I_Alert := PID1.uiAlertID;(*FBD id[151]*)
END_PROGRAM


CONFIGURATION Config0

  RESOURCE Res0 ON PLC
    VAR_GLOBAL
      lastErrorCode AT %MW1.15 : UINT;
    END_VAR
    VAR_GLOBAL
      ExpModDisconHistory AT %MB1.22 : BYTE;
    END_VAR
    VAR_GLOBAL
      STP_Setpoint AT %QW11.0 : INT := 230;
      STP_Kp AT %QW11.1 : INT := 5;
      STP_Ti AT %QW11.2 : UINT := 120;
      STP_Td AT %QW11.3 : UINT := 120;
    END_VAR
    VAR_GLOBAL
      LOC_DI1 AT %IX0.0 : BOOL := 0;
      LOC_DI2 AT %IX0.1 : BOOL := 0;
      LOC_DI3 AT %IX0.2 : BOOL := 0;
      LOC_DI4 AT %IX0.3 : BOOL := 0;
      LOC_DI5 AT %IX0.4 : BOOL := 0;
      LOC_DI6 AT %IX0.5 : BOOL := 0;
      LOC_DI7 AT %IX0.6 : BOOL := 0;
      LOC_DI8 AT %IX0.7 : BOOL := 0;
      LOC_AI1 AT %IW1.0 : INT := 0;
      LOC_AI2 AT %IW1.1 : INT := 0;
      AI3 AT %IW1.2 : INT := 0;
      AI4 AT %IW1.3 : INT := 0;
      AI5 AT %IW1.4 : INT := 0;
      AI6 AT %IW1.5 : INT := 0;
      AI7 AT %IW1.6 : INT := 0;
      AI8 AT %IW1.7 : INT := 0;
      LOC_DO1 AT %QX0.0 : BOOL := 0;
      LOC_DO2 AT %QX0.1 : BOOL := 0;
      LOC_DO3 AT %QX0.2 : BOOL := 0;
      LOC_DO4 AT %QX0.3 : BOOL := 0;
      DO5 AT %QX0.4 : BOOL := 0;
      DO6 AT %QX0.5 : BOOL := 0;
      DO7 AT %QX0.6 : BOOL := 0;
      DO8 AT %QX0.7 : BOOL := 0;
      LOC_AO1 AT %QW1.0 : INT := 0;
      AO2 AT %QW1.1 : INT := 0;
      AO3 AT %QW1.2 : INT := 0;
      AO4 AT %QW1.3 : INT := 0;
      FDI1_counter AT %MD5.0 : UDINT := 0;
      FDI1_frequency AT %MD16.0 : UDINT := 0;
      FDI1_reset_counter AT %MX6.0 : BOOL := 0;
      FDI2_counter AT %MD5.1 : UDINT := 0;
      FDI2_frequency AT %MD16.1 : UDINT := 0;
      FDI2_reset_counter AT %MX6.1 : BOOL := 0;
      FDI3_counter AT %MD5.2 : UDINT := 0;
      FDI3_frequency AT %MD16.2 : UDINT := 0;
      FDI3_reset_counter AT %MX6.2 : BOOL := 0;
      FDI4_counter AT %MD5.3 : UDINT := 0;
      FDI4_frequency AT %MD16.3 : UDINT := 0;
      FDI4_reset_counter AT %MX6.3 : BOOL := 0;
      KEY1 AT %MX2.4 : BOOL := 0;
      KEY2 AT %MX2.5 : BOOL := 0;
      KEY3 AT %MX2.6 : BOOL := 0;
      KEY4 AT %MX2.7 : BOOL := 0;
    END_VAR
    TASK task0(INTERVAL := T#20ms,PRIORITY := 0);
    PROGRAM instance0 WITH task0 : Control_VSD;
  END_RESOURCE
END_CONFIGURATION
