/*
 * DEBUGGER code
 * 
 * On "publish", when buffer is free, debugger stores arbitrary variables 
 * content into, and mark this buffer as filled
 * 
 * 
 * Buffer content is read asynchronously, (from non real time part), 
 * and then buffer marked free again.
 *  
 * 
 * */

#include "iec_types_all.h"
#include "POUS.h"
/*for memcpy*/
#include <string.h>
#include <stdio.h>

typedef unsigned int dbgvardsc_index_t;


/***
 * Declare programs 
 **/
extern DEMO_AI_4_20MA RES0__INSTANCE0;
extern DEMO_AI_0_20MA RES0__INSTANCE1;
extern DEMO_AI_0_10V RES0__INSTANCE2;
extern DEMO_AI_PT100 RES0__INSTANCE3;
extern DEMO_AI_PT1000 RES0__INSTANCE4;
extern DEMO_AI_RTD RES0__INSTANCE5;
extern DEMO_DI_DO RES0__INSTANCE6;
extern DEMO_TIMER_COUNTER RES0__INSTANCE7;
extern DEMO_STV900 RES0__INSTANCE8;
extern DEMO_GENERATORS RES0__INSTANCE9;
extern DEMO_AO_0_10V RES0__INSTANCE10;
extern DEMO_AO_4_20MA RES0__INSTANCE11;

/***
 * Declare global variables from resources and conf 
 **/
extern __IEC_UINT_p RES0__LASTERRORCODE;
extern __IEC_BYTE_p RES0__EXPMODDISCONHISTORY;
extern __IEC_BOOL_p RES0__MISSMODBUSRTUNODE0;
extern __IEC_UINT_p RES0__MISSCNTMODBUSRTUNODE0;
extern __IEC_BOOL_p RES0__SWITCHMODBUSRTUNODE0;
extern __IEC_BOOL_p RES0__DI1;
extern __IEC_BOOL_p RES0__DI2;
extern __IEC_BOOL_p RES0__DI3;
extern __IEC_BOOL_p RES0__DI4;
extern __IEC_BOOL_p RES0__DI5;
extern __IEC_BOOL_p RES0__DI6;
extern __IEC_BOOL_p RES0__DI7;
extern __IEC_BOOL_p RES0__DI8;
extern __IEC_INT_p RES0__AI1;
extern __IEC_INT_p RES0__AI2;
extern __IEC_INT_p RES0__AI3;
extern __IEC_INT_p RES0__AI4;
extern __IEC_INT_p RES0__AI5;
extern __IEC_INT_p RES0__AI6;
extern __IEC_INT_p RES0__AI7;
extern __IEC_INT_p RES0__AI8;
extern __IEC_BOOL_p RES0__DO1;
extern __IEC_BOOL_p RES0__DO2;
extern __IEC_BOOL_p RES0__DO3;
extern __IEC_BOOL_p RES0__DO4;
extern __IEC_BOOL_p RES0__DO5;
extern __IEC_BOOL_p RES0__DO6;
extern __IEC_BOOL_p RES0__DO7;
extern __IEC_BOOL_p RES0__DO8;
extern __IEC_INT_p RES0__AO1;
extern __IEC_INT_p RES0__AO2;
extern __IEC_INT_p RES0__AO3;
extern __IEC_INT_p RES0__AO4;
extern __IEC_UDINT_p RES0__FDI1_COUNTER;
extern __IEC_UDINT_p RES0__FDI1_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI1_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI2_COUNTER;
extern __IEC_UDINT_p RES0__FDI2_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI2_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI3_COUNTER;
extern __IEC_UDINT_p RES0__FDI3_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI3_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI4_COUNTER;
extern __IEC_UDINT_p RES0__FDI4_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI4_RESET_COUNTER;
extern __IEC_BOOL_p RES0__KEY1;
extern __IEC_BOOL_p RES0__KEY2;
extern __IEC_BOOL_p RES0__KEY3;
extern __IEC_BOOL_p RES0__KEY4;
extern __IEC_REAL_p RES0__HMI_RUN_FREQ;
extern __IEC_REAL_p RES0__HMI_SET_FREQ;
extern __IEC_REAL_p RES0__HMI_BUS_VOLT;
extern __IEC_REAL_p RES0__HMI_OUTPUT_CUR;
extern __IEC_REAL_p RES0__HMI_OUTPUT_PWR;
extern __IEC_REAL_p RES0__HMI_OUTPUT_TORQ;
extern __IEC_REAL_p RES0__HMI_CMD_SET_FREQ;
extern __IEC_INT_p RES0__HMI_RUN_SPEED;
extern __IEC_INT_p RES0__HMI_OUTPUT_VOLT;
extern __IEC_INT_p RES0__HMI_SW1;
extern __IEC_WORD_p RES0__HMI_SW2;
extern __IEC_INT_p RES0__HMI_FAULT_CODE;
extern __IEC_INT_p RES0__HMI_CMD_CTRL;
extern __IEC_UINT_p RES0__HMI_STV_COUNTER;
extern __IEC_BOOL_p RES0__HMI_STV_ONLINE;
extern __IEC_WORD_p RES0__RD1;
extern __IEC_WORD_p RES0__RD2;
extern __IEC_WORD_p RES0__RD3;
extern __IEC_WORD_p RES0__RD4;
extern __IEC_WORD_p RES0__RD5;
extern __IEC_WORD_p RES0__RD6;
extern __IEC_WORD_p RES0__RD7;
extern __IEC_WORD_p RES0__RD8;
extern __IEC_WORD_p RES0__RD9;
extern __IEC_WORD_p RES0__RD10;
extern __IEC_WORD_p RES0__RD11;
extern __IEC_WORD_p RES0__WR1;
extern __IEC_WORD_p RES0__WR2;
extern       DEMO_AI_4_20MA   RES0__INSTANCE0;
extern       DEMO_AI_0_20MA   RES0__INSTANCE1;
extern       DEMO_AI_0_10V   RES0__INSTANCE2;
extern       DEMO_AI_PT100   RES0__INSTANCE3;
extern       DEMO_AI_PT1000   RES0__INSTANCE4;
extern       DEMO_AI_RTD   RES0__INSTANCE5;
extern       DEMO_DI_DO   RES0__INSTANCE6;
extern       DEMO_TIMER_COUNTER   RES0__INSTANCE7;
extern       DEMO_STV900   RES0__INSTANCE8;
extern       DEMO_GENERATORS   RES0__INSTANCE9;
extern       DEMO_AO_0_10V   RES0__INSTANCE10;
extern       DEMO_AO_4_20MA   RES0__INSTANCE11;

typedef const struct {
    void *ptr;
    __IEC_types_enum type;
} dbgvardsc_t;

const dbgvardsc_t dbgvardsc[] = {
{&(RES0__LASTERRORCODE), UINT_O_ENUM},
{&(RES0__EXPMODDISCONHISTORY), BYTE_O_ENUM},
{&(RES0__MISSMODBUSRTUNODE0), BOOL_O_ENUM},
{&(RES0__MISSCNTMODBUSRTUNODE0), UINT_O_ENUM},
{&(RES0__SWITCHMODBUSRTUNODE0), BOOL_O_ENUM},
{&(RES0__DI1), BOOL_P_ENUM},
{&(RES0__DI2), BOOL_P_ENUM},
{&(RES0__DI3), BOOL_P_ENUM},
{&(RES0__DI4), BOOL_P_ENUM},
{&(RES0__DI5), BOOL_P_ENUM},
{&(RES0__DI6), BOOL_P_ENUM},
{&(RES0__DI7), BOOL_P_ENUM},
{&(RES0__DI8), BOOL_P_ENUM},
{&(RES0__AI1), INT_P_ENUM},
{&(RES0__AI2), INT_P_ENUM},
{&(RES0__AI3), INT_P_ENUM},
{&(RES0__AI4), INT_P_ENUM},
{&(RES0__AI5), INT_P_ENUM},
{&(RES0__AI6), INT_P_ENUM},
{&(RES0__AI7), INT_P_ENUM},
{&(RES0__AI8), INT_P_ENUM},
{&(RES0__DO1), BOOL_O_ENUM},
{&(RES0__DO2), BOOL_O_ENUM},
{&(RES0__DO3), BOOL_O_ENUM},
{&(RES0__DO4), BOOL_O_ENUM},
{&(RES0__DO5), BOOL_O_ENUM},
{&(RES0__DO6), BOOL_O_ENUM},
{&(RES0__DO7), BOOL_O_ENUM},
{&(RES0__DO8), BOOL_O_ENUM},
{&(RES0__AO1), INT_O_ENUM},
{&(RES0__AO2), INT_O_ENUM},
{&(RES0__AO3), INT_O_ENUM},
{&(RES0__AO4), INT_O_ENUM},
{&(RES0__FDI1_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI1_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI1_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI2_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI2_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI2_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI3_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI3_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI3_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI4_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI4_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI4_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__KEY1), BOOL_O_ENUM},
{&(RES0__KEY2), BOOL_O_ENUM},
{&(RES0__KEY3), BOOL_O_ENUM},
{&(RES0__KEY4), BOOL_O_ENUM},
{&(RES0__HMI_RUN_FREQ), REAL_O_ENUM},
{&(RES0__HMI_SET_FREQ), REAL_O_ENUM},
{&(RES0__HMI_BUS_VOLT), REAL_O_ENUM},
{&(RES0__HMI_OUTPUT_CUR), REAL_O_ENUM},
{&(RES0__HMI_OUTPUT_PWR), REAL_O_ENUM},
{&(RES0__HMI_OUTPUT_TORQ), REAL_O_ENUM},
{&(RES0__HMI_CMD_SET_FREQ), REAL_O_ENUM},
{&(RES0__HMI_RUN_SPEED), INT_O_ENUM},
{&(RES0__HMI_OUTPUT_VOLT), INT_O_ENUM},
{&(RES0__HMI_SW1), INT_O_ENUM},
{&(RES0__HMI_SW2), WORD_O_ENUM},
{&(RES0__HMI_FAULT_CODE), INT_O_ENUM},
{&(RES0__HMI_CMD_CTRL), INT_O_ENUM},
{&(RES0__HMI_STV_COUNTER), UINT_O_ENUM},
{&(RES0__HMI_STV_ONLINE), BOOL_O_ENUM},
{&(RES0__RD1), WORD_P_ENUM},
{&(RES0__RD2), WORD_P_ENUM},
{&(RES0__RD3), WORD_P_ENUM},
{&(RES0__RD4), WORD_P_ENUM},
{&(RES0__RD5), WORD_P_ENUM},
{&(RES0__RD6), WORD_P_ENUM},
{&(RES0__RD7), WORD_P_ENUM},
{&(RES0__RD8), WORD_P_ENUM},
{&(RES0__RD9), WORD_P_ENUM},
{&(RES0__RD10), WORD_P_ENUM},
{&(RES0__RD11), WORD_P_ENUM},
{&(RES0__WR1), WORD_O_ENUM},
{&(RES0__WR2), WORD_O_ENUM},
{&(RES0__INSTANCE0.ADC_MAX), REAL_ENUM},
{&(RES0__INSTANCE0.ADC_MIN), REAL_ENUM},
{&(RES0__INSTANCE0.AI3_CUR), REAL_ENUM},
{&(RES0__INSTANCE0.AI3_PHYS), REAL_ENUM},
{&(RES0__INSTANCE0.AI3_PRC), REAL_ENUM},
{&(RES0__INSTANCE0.AI3_H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE0.AI3_L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.EN), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.AI_INP), INT_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.IN_MAX), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.IN_MIN), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.OUT_MAX), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.OUT_MIN), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.TEMP), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_EQ12_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_NOT43_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_SEL10_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.CUR_SCALE._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.EN), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.AI_INP), INT_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.IN_MAX), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.IN_MIN), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.OUT_MAX), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.OUT_MIN), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.TEMP), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_EQ12_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_NOT43_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_SEL10_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.PRC_SCALE._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.EN), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.AI_INP), INT_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.IN_MAX), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.IN_MIN), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.OUT_MAX), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.OUT_MIN), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.TEMP), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_EQ12_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_NOT43_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_SEL10_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.PHYS_SCALE._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.ADC_MAX), REAL_ENUM},
{&(RES0__INSTANCE1.ADC_MIN), REAL_ENUM},
{&(RES0__INSTANCE1.AI2_CUR), REAL_ENUM},
{&(RES0__INSTANCE1.AI2_PHYS), REAL_ENUM},
{&(RES0__INSTANCE1.AI2_PRC), REAL_ENUM},
{&(RES0__INSTANCE1.AI2_H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.EN), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.AI_INP), INT_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.IN_MAX), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.IN_MIN), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.OUT_MAX), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.OUT_MIN), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.TEMP), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_EQ12_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_NOT43_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_SEL10_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.CUR_SCALE._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.EN), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.AI_INP), INT_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.IN_MAX), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.IN_MIN), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.OUT_MAX), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.OUT_MIN), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.TEMP), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_EQ12_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_NOT43_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_SEL10_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.PRC_SCALE._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.EN), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.AI_INP), INT_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.IN_MAX), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.IN_MIN), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.OUT_MAX), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.OUT_MIN), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.TEMP), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_EQ12_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_NOT43_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_SEL10_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE1.PHYS_SCALE._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.ADC_MAX), REAL_ENUM},
{&(RES0__INSTANCE2.ADC_MIN), REAL_ENUM},
{&(RES0__INSTANCE2.AI1_VOLT), REAL_ENUM},
{&(RES0__INSTANCE2.AI1_H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE2.AI1_PHYS), REAL_ENUM},
{&(RES0__INSTANCE2.AI1_PRC), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.EN), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.AI_INP), INT_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.IN_MAX), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.IN_MIN), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.OUT_MAX), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.OUT_MIN), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.TEMP), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_EQ12_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_NOT43_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_SEL10_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.VOLT_SCALE._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.EN), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.AI_INP), INT_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.IN_MAX), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.IN_MIN), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.OUT_MAX), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.OUT_MIN), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.TEMP), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_EQ12_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_NOT43_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_SEL10_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.PRC_SCALE._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.EN), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.AI_INP), INT_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.IN_MAX), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.IN_MIN), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.OUT_MAX), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.OUT_MIN), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.TEMP), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_EQ12_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_NOT43_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_SEL10_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE2.PHYS_SCALE._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE3.AI5_PT100), REAL_ENUM},
{&(RES0__INSTANCE3.AI5_H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE3.AI5_L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE.EN), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE.ENO), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE.AI_INP), INT_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE.TEMP), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE3.PT100_SCALE._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE4.AI6_PT1000), REAL_ENUM},
{&(RES0__INSTANCE4.AI6_H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE4.AI6_L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE.EN), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE.ENO), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE.AI_INP), INT_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE.TEMP), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE4.PT1000_SCALE._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE5.AI7_RTD), REAL_ENUM},
{&(RES0__INSTANCE5.AI7_H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE5.AI7_L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0.AI_INP), INT_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0.AI_OUT), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0.TEMP), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0.AI_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_EQ84_OUT), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_EQ98_OUT), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_INT_TO_REAL47_OUT), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE5.AI_RTD_0._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.INP_DI), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TIMER_ON), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TIMER_OFF), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.OUT_DO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.ET_TIMER_ON), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.ET_TIMER_OFF), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.START), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.STOP), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_0.IN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_0.PT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_0.Q), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_0.ET), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_0.STATE), SINT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_0.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_0.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_0.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_1.EN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_1.IN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_1.PT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_1.Q), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_1.ET), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_1.STATE), SINT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_1.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_1.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.TON_1.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.T_TIMER_ON), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.T_TIMER_OFF), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.RS_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.RS_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.RS_0.S), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.RS_0.R1), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.RS_0.Q1), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.RS_1.EN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.RS_1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.RS_1.S), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.RS_1.R1), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0.RS_1.Q1), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0._TMP_MUL8_OUT), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0._TMP_INT_TO_TIME2_OUT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0._TMP_MUL47_OUT), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0._TMP_INT_TO_TIME45_OUT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0._TMP_SUB_TIME39_OUT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0._TMP_TIME_TO_INT28_OUT), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0._TMP_DIV38_OUT), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0._TMP_SUB_TIME50_OUT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0._TMP_TIME_TO_INT36_OUT), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_0._TMP_DIV53_OUT), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.EN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.INP_DI), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TIMER_ON), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TIMER_OFF), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.OUT_DO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.ET_TIMER_ON), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.ET_TIMER_OFF), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.START), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.STOP), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_0.IN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_0.PT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_0.Q), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_0.ET), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_0.STATE), SINT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_0.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_0.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_0.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_1.EN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_1.IN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_1.PT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_1.Q), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_1.ET), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_1.STATE), SINT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_1.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_1.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.TON_1.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.T_TIMER_ON), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.T_TIMER_OFF), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.RS_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.RS_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.RS_0.S), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.RS_0.R1), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.RS_0.Q1), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.RS_1.EN), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.RS_1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.RS_1.S), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.RS_1.R1), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1.RS_1.Q1), BOOL_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1._TMP_MUL8_OUT), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1._TMP_INT_TO_TIME2_OUT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1._TMP_MUL47_OUT), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1._TMP_INT_TO_TIME45_OUT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1._TMP_SUB_TIME39_OUT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1._TMP_TIME_TO_INT28_OUT), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1._TMP_DIV38_OUT), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1._TMP_SUB_TIME50_OUT), TIME_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1._TMP_TIME_TO_INT36_OUT), INT_ENUM},
{&(RES0__INSTANCE6.DO_ON_OFF_1._TMP_DIV53_OUT), INT_ENUM},
{&(RES0__INSTANCE6._TMP_OR2_OUT), BOOL_ENUM},
{&(RES0__INSTANCE6._TMP_OR19_OUT), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.BLINK), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.START), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.STOP), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_0.IN), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_0.PT), TIME_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_0.Q), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_0.ET), TIME_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_0.STATE), SINT_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_0.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_0.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_0.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_1.EN), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_1.IN), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_1.PT), TIME_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_1.Q), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_1.ET), TIME_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_1.STATE), SINT_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_1.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_1.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.TON_1.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.RS_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.RS_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.RS_0.S), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.RS_0.R1), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.RS_0.Q1), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.RS_1.EN), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.RS_1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.RS_1.S), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.RS_1.R1), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.RS_1.Q1), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.COUNTER), INT_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.R_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.R_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.R_0.CLK), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.R_0.Q), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0.R_0.M), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0._TMP_ADD58_ENO), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0._TMP_ADD58_OUT), INT_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0._TMP_GT75_OUT), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0._TMP_MOVE67_ENO), BOOL_ENUM},
{&(RES0__INSTANCE7.TIMER_COUNTER_0._TMP_MOVE67_OUT), INT_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RD1), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RD2), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RD3), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RD4), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RD5), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RD6), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RD7), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RD8), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RD9), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RD10), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RD11), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.CMD_CTRL), INT_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.CMD_SET_FREQ), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RUN_FREQ), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.SET_FREQ), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.BUS_VOLT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.OUTPUT_VOLT), INT_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.OUTPUT_CUR), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.RUN_SPEED), INT_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.OUTPUT_PWR), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.OUTPUT_TORQ), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.SW1), INT_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.SW2), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.FAULT_CODE), INT_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.WR1), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0.WR2), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_WORD_TO_REAL1_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_DIV3_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_WORD_TO_REAL10_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_DIV7_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_WORD_TO_REAL16_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_DIV13_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_WORD_TO_INT42_OUT), INT_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_WORD_TO_REAL35_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_DIV23_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_WORD_TO_INT41_OUT), INT_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_WORD_TO_REAL45_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_DIV46_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_WORD_TO_REAL55_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_DIV53_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_WORD_TO_INT60_OUT), INT_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_WORD_TO_INT66_OUT), INT_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_INT_TO_WORD73_OUT), WORD_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_MUL77_OUT), REAL_ENUM},
{&(RES0__INSTANCE8.COM_STV900_0._TMP_REAL_TO_WORD79_OUT), WORD_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.START), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.STOP), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_0.IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_0.PT), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_0.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_0.ET), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_0.STATE), SINT_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_0.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_0.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_0.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_1.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_1.IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_1.PT), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_1.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_1.ET), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_1.STATE), SINT_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_1.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_1.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.TON_1.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.RS_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.RS_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.RS_0.S), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.RS_0.R1), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.RS_0.Q1), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.COUNTER_INT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.R_TRIG_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.R_TRIG_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.R_TRIG_0.CLK), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.R_TRIG_0.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.R_TRIG_0.M), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.AMPLITUDE), INT_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.AMP), INT_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.SPEED), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.SHIFT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0.OUT_SIN), REAL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_LIMIT85_OUT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_ADD58_ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_ADD58_OUT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_GE66_OUT), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_MOVE67_ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_MOVE67_OUT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_INT_TO_REAL96_OUT), REAL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_DIV97_OUT), REAL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_SIN99_OUT), REAL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_INT_TO_REAL108_OUT), REAL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_DIV110_OUT), REAL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_MUL100_OUT), REAL_ENUM},
{&(RES0__INSTANCE9.GEN_SIN_0._TMP_ADD101_OUT), REAL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.AMPLITUDE), INT_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.SPEED), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.OUT_INT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.OUT_REAL), REAL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.START), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.STOP), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_0.IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_0.PT), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_0.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_0.ET), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_0.STATE), SINT_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_0.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_0.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_0.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_1.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_1.IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_1.PT), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_1.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_1.ET), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_1.STATE), SINT_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_1.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_1.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.TON_1.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_0.CLK), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_0.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_0.M), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.AMP), INT_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_1.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_1.CLK), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_1.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_1.M), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.RS_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.RS_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.RS_0.S), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.RS_0.R1), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.RS_0.Q1), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_2.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_2.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_2.CLK), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_2.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_2.M), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.DIRECT), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_3.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_3.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_3.CLK), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_3.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0.R_TRIG_3.M), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_LIMIT85_OUT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_LE95_OUT), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_EQ124_OUT), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_OR125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_GE122_OUT), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_EQ130_OUT), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_OR128_OUT), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_AND96_OUT), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_ADD58_ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_ADD58_OUT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_AND100_OUT), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_SUB109_ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_SUB109_OUT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_PILA_0._TMP_INT_TO_REAL110_OUT), REAL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.START), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.STOP), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_0.IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_0.PT), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_0.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_0.ET), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_0.STATE), SINT_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_0.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_0.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_0.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_1.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_1.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_1.IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_1.PT), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_1.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_1.ET), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_1.STATE), SINT_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_1.PREV_IN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_1.CURRENT_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.TON_1.START_TIME), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.RS_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.RS_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.RS_0.S), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.RS_0.R1), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.RS_0.Q1), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.OUT_INT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.R_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.R_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.R_0.CLK), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.R_0.Q), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.R_0.M), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.AMPLITUDE), INT_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.AMP), INT_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0.SPEED), TIME_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0._TMP_LIMIT85_OUT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0._TMP_ADD58_ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0._TMP_ADD58_OUT), INT_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0._TMP_GT91_OUT), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0._TMP_MOVE67_ENO), BOOL_ENUM},
{&(RES0__INSTANCE9.GEN_CYCLIC_0._TMP_MOVE67_OUT), INT_ENUM},
{&(RES0__INSTANCE10.INPUT_SIGNAL), REAL_ENUM},
{&(RES0__INSTANCE10.AO1_H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE10.AO1_L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0.INP_SIGNAL), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0.DAC_MAX), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0.DAC_MIN), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0.AO_OUT), INT_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0.TEMP), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0.AO_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_GT133_OUT), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_LT134_OUT), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_REAL_TO_INT138_ENO), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_REAL_TO_INT138_OUT), INT_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_REAL_TO_INT139_ENO), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_REAL_TO_INT139_OUT), INT_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_REAL_TO_INT140_ENO), BOOL_ENUM},
{&(RES0__INSTANCE10.AO_VOLT_DAC_0._TMP_REAL_TO_INT140_OUT), INT_ENUM},
{&(RES0__INSTANCE10.SET), REAL_ENUM},
{&(RES0__INSTANCE11.AO3_H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE11.AO3_L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0.INP_SIGNAL), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0.DAC_MAX), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0.DAC_MIN), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0.AO_OUT), INT_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0.TEMP), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0.H_LIM), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0.L_LIM), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0.AO_OUT_CALC), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_GT133_OUT), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_SEL97_OUT), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_LT134_OUT), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_SEL87_OUT), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_SUB2_OUT), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_SUB45_OUT), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_SUB46_OUT), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_MUL52_OUT), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_DIV56_OUT), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_ADD60_OUT), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_AND115_OUT), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_MOVE119_ENO), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_MOVE119_OUT), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_REAL_TO_INT138_ENO), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_REAL_TO_INT138_OUT), INT_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_AND125_OUT), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_MOVE121_ENO), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_MOVE121_OUT), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_REAL_TO_INT139_ENO), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_REAL_TO_INT139_OUT), INT_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_AND129_OUT), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_MOVE128_ENO), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_MOVE128_OUT), REAL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_REAL_TO_INT140_ENO), BOOL_ENUM},
{&(RES0__INSTANCE11.AO_CUR_DAC_0._TMP_REAL_TO_INT140_OUT), INT_ENUM},
{&(RES0__INSTANCE11.SET), REAL_ENUM}
};
const unsigned int dbgvardsc_size = sizeof(dbgvardsc)/sizeof(dbgvardsc_t);

const dbgvardsc_index_t retain_list[] = {

};
const unsigned int retain_list_size = sizeof(retain_list)/sizeof(dbgvardsc_index_t);



void __init_debug(void)
{

}