#ifndef __POUS_H
#define __POUS_H

#include "accessor.h"
#include "iec_std_lib.h"

// FUNCTION_BLOCK AI_SCALE
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(INT,AI_INP)
  __DECLARE_VAR(REAL,IN_MAX)
  __DECLARE_VAR(REAL,IN_MIN)
  __DECLARE_VAR(REAL,OUT_MAX)
  __DECLARE_VAR(REAL,OUT_MIN)
  __DECLARE_VAR(REAL,AI_OUT)
  __DECLARE_VAR(BOOL,H_LIM)
  __DECLARE_VAR(BOOL,L_LIM)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,TEMP)
  __DECLARE_VAR(REAL,AI_OUT_CALC)
  __DECLARE_VAR(BOOL,_TMP_EQ84_OUT)
  __DECLARE_VAR(BOOL,_TMP_SEL97_OUT)
  __DECLARE_VAR(BOOL,_TMP_EQ98_OUT)
  __DECLARE_VAR(BOOL,_TMP_SEL87_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB2_OUT)
  __DECLARE_VAR(BOOL,_TMP_EQ12_OUT)
  __DECLARE_VAR(BOOL,_TMP_NOT43_OUT)
  __DECLARE_VAR(REAL,_TMP_SEL10_OUT)
  __DECLARE_VAR(REAL,_TMP_INT_TO_REAL47_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB45_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB46_OUT)
  __DECLARE_VAR(REAL,_TMP_MUL52_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV56_OUT)
  __DECLARE_VAR(REAL,_TMP_ADD60_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND115_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE119_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE119_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND125_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE121_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE121_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND129_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE128_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE128_OUT)

} AI_SCALE;

void AI_SCALE_init__(AI_SCALE *data__, BOOL retain);
// Code part
void AI_SCALE_body__(AI_SCALE *data__);
// PROGRAM DEMO_AI_4_20MA
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,ADC_MAX)
  __DECLARE_VAR(REAL,ADC_MIN)
  __DECLARE_VAR(REAL,AI3_CUR)
  __DECLARE_VAR(REAL,AI3_PHYS)
  __DECLARE_VAR(REAL,AI3_PRC)
  __DECLARE_VAR(BOOL,AI3_H_LIM)
  __DECLARE_VAR(BOOL,AI3_L_LIM)
  AI_SCALE CUR_SCALE;
  AI_SCALE PRC_SCALE;
  AI_SCALE PHYS_SCALE;

} DEMO_AI_4_20MA;

void DEMO_AI_4_20MA_init__(DEMO_AI_4_20MA *data__, BOOL retain);
// Code part
void DEMO_AI_4_20MA_body__(DEMO_AI_4_20MA *data__);
// PROGRAM DEMO_AI_0_20MA
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,ADC_MAX)
  __DECLARE_VAR(REAL,ADC_MIN)
  __DECLARE_VAR(REAL,AI2_CUR)
  __DECLARE_VAR(REAL,AI2_PHYS)
  __DECLARE_VAR(REAL,AI2_PRC)
  __DECLARE_VAR(BOOL,AI2_H_LIM)
  AI_SCALE CUR_SCALE;
  AI_SCALE PRC_SCALE;
  AI_SCALE PHYS_SCALE;

} DEMO_AI_0_20MA;

void DEMO_AI_0_20MA_init__(DEMO_AI_0_20MA *data__, BOOL retain);
// Code part
void DEMO_AI_0_20MA_body__(DEMO_AI_0_20MA *data__);
// PROGRAM DEMO_AI_0_10V
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,ADC_MAX)
  __DECLARE_VAR(REAL,ADC_MIN)
  __DECLARE_VAR(REAL,AI1_VOLT)
  __DECLARE_VAR(BOOL,AI1_H_LIM)
  __DECLARE_VAR(REAL,AI1_PHYS)
  __DECLARE_VAR(REAL,AI1_PRC)
  AI_SCALE VOLT_SCALE;
  AI_SCALE PRC_SCALE;
  AI_SCALE PHYS_SCALE;

} DEMO_AI_0_10V;

void DEMO_AI_0_10V_init__(DEMO_AI_0_10V *data__, BOOL retain);
// Code part
void DEMO_AI_0_10V_body__(DEMO_AI_0_10V *data__);
// FUNCTION_BLOCK AI_PT100_SCALE
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(INT,AI_INP)
  __DECLARE_VAR(REAL,AI_OUT)
  __DECLARE_VAR(BOOL,H_LIM)
  __DECLARE_VAR(BOOL,L_LIM)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,TEMP)
  __DECLARE_VAR(REAL,AI_OUT_CALC)
  __DECLARE_VAR(BOOL,_TMP_EQ84_OUT)
  __DECLARE_VAR(BOOL,_TMP_SEL97_OUT)
  __DECLARE_VAR(BOOL,_TMP_EQ98_OUT)
  __DECLARE_VAR(BOOL,_TMP_SEL87_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB2_OUT)
  __DECLARE_VAR(REAL,_TMP_INT_TO_REAL47_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB45_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB46_OUT)
  __DECLARE_VAR(REAL,_TMP_MUL52_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV56_OUT)
  __DECLARE_VAR(REAL,_TMP_ADD60_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND115_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE119_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE119_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND125_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE121_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE121_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND129_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE128_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE128_OUT)

} AI_PT100_SCALE;

void AI_PT100_SCALE_init__(AI_PT100_SCALE *data__, BOOL retain);
// Code part
void AI_PT100_SCALE_body__(AI_PT100_SCALE *data__);
// PROGRAM DEMO_AI_PT100
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,AI5_PT100)
  __DECLARE_VAR(BOOL,AI5_H_LIM)
  __DECLARE_VAR(BOOL,AI5_L_LIM)
  AI_PT100_SCALE PT100_SCALE;

} DEMO_AI_PT100;

void DEMO_AI_PT100_init__(DEMO_AI_PT100 *data__, BOOL retain);
// Code part
void DEMO_AI_PT100_body__(DEMO_AI_PT100 *data__);
// FUNCTION_BLOCK AI_PT1000_SCALE
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(INT,AI_INP)
  __DECLARE_VAR(REAL,AI_OUT)
  __DECLARE_VAR(BOOL,H_LIM)
  __DECLARE_VAR(BOOL,L_LIM)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,TEMP)
  __DECLARE_VAR(REAL,AI_OUT_CALC)
  __DECLARE_VAR(BOOL,_TMP_EQ84_OUT)
  __DECLARE_VAR(BOOL,_TMP_SEL97_OUT)
  __DECLARE_VAR(BOOL,_TMP_EQ98_OUT)
  __DECLARE_VAR(BOOL,_TMP_SEL87_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB2_OUT)
  __DECLARE_VAR(REAL,_TMP_INT_TO_REAL47_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB45_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB46_OUT)
  __DECLARE_VAR(REAL,_TMP_MUL52_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV56_OUT)
  __DECLARE_VAR(REAL,_TMP_ADD60_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND115_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE119_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE119_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND125_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE121_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE121_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND129_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE128_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE128_OUT)

} AI_PT1000_SCALE;

void AI_PT1000_SCALE_init__(AI_PT1000_SCALE *data__, BOOL retain);
// Code part
void AI_PT1000_SCALE_body__(AI_PT1000_SCALE *data__);
// PROGRAM DEMO_AI_PT1000
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,AI6_PT1000)
  __DECLARE_VAR(BOOL,AI6_H_LIM)
  __DECLARE_VAR(BOOL,AI6_L_LIM)
  AI_PT1000_SCALE PT1000_SCALE;

} DEMO_AI_PT1000;

void DEMO_AI_PT1000_init__(DEMO_AI_PT1000 *data__, BOOL retain);
// Code part
void DEMO_AI_PT1000_body__(DEMO_AI_PT1000 *data__);
// FUNCTION_BLOCK AI_RTD_SCALE
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(INT,AI_INP)
  __DECLARE_VAR(REAL,AI_OUT)
  __DECLARE_VAR(BOOL,H_LIM)
  __DECLARE_VAR(BOOL,L_LIM)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,TEMP)
  __DECLARE_VAR(REAL,AI_OUT_CALC)
  __DECLARE_VAR(BOOL,_TMP_EQ84_OUT)
  __DECLARE_VAR(BOOL,_TMP_SEL97_OUT)
  __DECLARE_VAR(BOOL,_TMP_EQ98_OUT)
  __DECLARE_VAR(BOOL,_TMP_SEL87_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB2_OUT)
  __DECLARE_VAR(REAL,_TMP_INT_TO_REAL47_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB45_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB46_OUT)
  __DECLARE_VAR(REAL,_TMP_MUL52_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV56_OUT)
  __DECLARE_VAR(REAL,_TMP_ADD60_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND115_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE119_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE119_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND125_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE121_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE121_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND129_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE128_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE128_OUT)

} AI_RTD_SCALE;

void AI_RTD_SCALE_init__(AI_RTD_SCALE *data__, BOOL retain);
// Code part
void AI_RTD_SCALE_body__(AI_RTD_SCALE *data__);
// PROGRAM DEMO_AI_RTD
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,AI7_RTD)
  __DECLARE_VAR(BOOL,AI7_H_LIM)
  __DECLARE_VAR(BOOL,AI7_L_LIM)
  AI_RTD_SCALE AI_RTD_0;

} DEMO_AI_RTD;

void DEMO_AI_RTD_init__(DEMO_AI_RTD *data__, BOOL retain);
// Code part
void DEMO_AI_RTD_body__(DEMO_AI_RTD *data__);
// FUNCTION_BLOCK AO_SCALE
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(REAL,INP_SIGNAL)
  __DECLARE_VAR(REAL,DAC_MAX)
  __DECLARE_VAR(REAL,DAC_MIN)
  __DECLARE_VAR(INT,AO_OUT)
  __DECLARE_VAR(BOOL,H_LIM)
  __DECLARE_VAR(BOOL,L_LIM)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,TEMP)
  __DECLARE_VAR(REAL,AO_OUT_CALC)
  __DECLARE_VAR(BOOL,_TMP_GT133_OUT)
  __DECLARE_VAR(BOOL,_TMP_SEL97_OUT)
  __DECLARE_VAR(BOOL,_TMP_LT134_OUT)
  __DECLARE_VAR(BOOL,_TMP_SEL87_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB2_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB45_OUT)
  __DECLARE_VAR(REAL,_TMP_SUB46_OUT)
  __DECLARE_VAR(REAL,_TMP_MUL52_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV56_OUT)
  __DECLARE_VAR(REAL,_TMP_ADD60_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND115_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE119_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE119_OUT)
  __DECLARE_VAR(BOOL,_TMP_REAL_TO_INT138_ENO)
  __DECLARE_VAR(INT,_TMP_REAL_TO_INT138_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND125_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE121_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE121_OUT)
  __DECLARE_VAR(BOOL,_TMP_REAL_TO_INT139_ENO)
  __DECLARE_VAR(INT,_TMP_REAL_TO_INT139_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND129_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE128_ENO)
  __DECLARE_VAR(REAL,_TMP_MOVE128_OUT)
  __DECLARE_VAR(BOOL,_TMP_REAL_TO_INT140_ENO)
  __DECLARE_VAR(INT,_TMP_REAL_TO_INT140_OUT)

} AO_SCALE;

void AO_SCALE_init__(AO_SCALE *data__, BOOL retain);
// Code part
void AO_SCALE_body__(AO_SCALE *data__);
// PROGRAM DEMO_AO_0_10V
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,INPUT_SIGNAL)
  __DECLARE_VAR(BOOL,AO1_H_LIM)
  __DECLARE_VAR(BOOL,AO1_L_LIM)
  AO_SCALE AO_VOLT_DAC_0;
  __DECLARE_VAR(REAL,SET)

} DEMO_AO_0_10V;

void DEMO_AO_0_10V_init__(DEMO_AO_0_10V *data__, BOOL retain);
// Code part
void DEMO_AO_0_10V_body__(DEMO_AO_0_10V *data__);
// PROGRAM DEMO_AO_4_20MA
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  __DECLARE_VAR(BOOL,AO3_H_LIM)
  __DECLARE_VAR(BOOL,AO3_L_LIM)
  AO_SCALE AO_CUR_DAC_0;
  __DECLARE_VAR(REAL,SET)

} DEMO_AO_4_20MA;

void DEMO_AO_4_20MA_init__(DEMO_AO_4_20MA *data__, BOOL retain);
// Code part
void DEMO_AO_4_20MA_body__(DEMO_AO_4_20MA *data__);
// FUNCTION_BLOCK DO_ON_OFF
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,INP_DI)
  __DECLARE_VAR(INT,TIMER_ON)
  __DECLARE_VAR(INT,TIMER_OFF)
  __DECLARE_VAR(BOOL,OUT_DO)
  __DECLARE_VAR(INT,ET_TIMER_ON)
  __DECLARE_VAR(INT,ET_TIMER_OFF)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(BOOL,START)
  __DECLARE_VAR(BOOL,STOP)
  TON TON_0;
  TON TON_1;
  __DECLARE_VAR(TIME,T_TIMER_ON)
  __DECLARE_VAR(TIME,T_TIMER_OFF)
  RS RS_0;
  RS RS_1;
  __DECLARE_VAR(INT,_TMP_MUL8_OUT)
  __DECLARE_VAR(TIME,_TMP_INT_TO_TIME2_OUT)
  __DECLARE_VAR(INT,_TMP_MUL47_OUT)
  __DECLARE_VAR(TIME,_TMP_INT_TO_TIME45_OUT)
  __DECLARE_VAR(TIME,_TMP_SUB_TIME39_OUT)
  __DECLARE_VAR(INT,_TMP_TIME_TO_INT28_OUT)
  __DECLARE_VAR(INT,_TMP_DIV38_OUT)
  __DECLARE_VAR(TIME,_TMP_SUB_TIME50_OUT)
  __DECLARE_VAR(INT,_TMP_TIME_TO_INT36_OUT)
  __DECLARE_VAR(INT,_TMP_DIV53_OUT)

} DO_ON_OFF;

void DO_ON_OFF_init__(DO_ON_OFF *data__, BOOL retain);
// Code part
void DO_ON_OFF_body__(DO_ON_OFF *data__);
// PROGRAM DEMO_DI_DO
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  DO_ON_OFF DO_ON_OFF_0;
  DO_ON_OFF DO_ON_OFF_1;
  __DECLARE_VAR(BOOL,_TMP_OR2_OUT)
  __DECLARE_VAR(BOOL,_TMP_OR19_OUT)

} DEMO_DI_DO;

void DEMO_DI_DO_init__(DEMO_DI_DO *data__, BOOL retain);
// Code part
void DEMO_DI_DO_body__(DEMO_DI_DO *data__);
// FUNCTION_BLOCK TIMER_COUNTER
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,BLINK)
  __DECLARE_VAR(INT,COUNTER)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(BOOL,START)
  __DECLARE_VAR(BOOL,STOP)
  TON TON_0;
  TON TON_1;
  RS RS_0;
  RS RS_1;
  R_TRIG R_0;
  __DECLARE_VAR(BOOL,_TMP_ADD58_ENO)
  __DECLARE_VAR(INT,_TMP_ADD58_OUT)
  __DECLARE_VAR(BOOL,_TMP_GT75_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE67_ENO)
  __DECLARE_VAR(INT,_TMP_MOVE67_OUT)

} TIMER_COUNTER;

void TIMER_COUNTER_init__(TIMER_COUNTER *data__, BOOL retain);
// Code part
void TIMER_COUNTER_body__(TIMER_COUNTER *data__);
// PROGRAM DEMO_TIMER_COUNTER
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  TIMER_COUNTER TIMER_COUNTER_0;

} DEMO_TIMER_COUNTER;

void DEMO_TIMER_COUNTER_init__(DEMO_TIMER_COUNTER *data__, BOOL retain);
// Code part
void DEMO_TIMER_COUNTER_body__(DEMO_TIMER_COUNTER *data__);
// FUNCTION_BLOCK GEN_CYCLIC
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(INT,OUT_INT)
  __DECLARE_VAR(INT,AMPLITUDE)
  __DECLARE_VAR(TIME,SPEED)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(BOOL,START)
  __DECLARE_VAR(BOOL,STOP)
  TON TON_0;
  TON TON_1;
  RS RS_0;
  R_TRIG R_0;
  __DECLARE_VAR(INT,AMP)
  __DECLARE_VAR(INT,_TMP_LIMIT85_OUT)
  __DECLARE_VAR(BOOL,_TMP_ADD58_ENO)
  __DECLARE_VAR(INT,_TMP_ADD58_OUT)
  __DECLARE_VAR(BOOL,_TMP_GT91_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE67_ENO)
  __DECLARE_VAR(INT,_TMP_MOVE67_OUT)

} GEN_CYCLIC;

void GEN_CYCLIC_init__(GEN_CYCLIC *data__, BOOL retain);
// Code part
void GEN_CYCLIC_body__(GEN_CYCLIC *data__);
// FUNCTION_BLOCK GEN_SIN
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(INT,AMPLITUDE)
  __DECLARE_VAR(REAL,OUT_SIN)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(BOOL,START)
  __DECLARE_VAR(BOOL,STOP)
  TON TON_0;
  TON TON_1;
  RS RS_0;
  __DECLARE_VAR(INT,COUNTER_INT)
  R_TRIG R_TRIG_0;
  __DECLARE_VAR(INT,AMP)
  __DECLARE_VAR(TIME,SPEED)
  __DECLARE_VAR(INT,SHIFT)
  __DECLARE_VAR(INT,_TMP_LIMIT85_OUT)
  __DECLARE_VAR(BOOL,_TMP_ADD58_ENO)
  __DECLARE_VAR(INT,_TMP_ADD58_OUT)
  __DECLARE_VAR(BOOL,_TMP_GE66_OUT)
  __DECLARE_VAR(BOOL,_TMP_MOVE67_ENO)
  __DECLARE_VAR(INT,_TMP_MOVE67_OUT)
  __DECLARE_VAR(REAL,_TMP_INT_TO_REAL96_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV97_OUT)
  __DECLARE_VAR(REAL,_TMP_SIN99_OUT)
  __DECLARE_VAR(REAL,_TMP_INT_TO_REAL108_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV110_OUT)
  __DECLARE_VAR(REAL,_TMP_MUL100_OUT)
  __DECLARE_VAR(REAL,_TMP_ADD101_OUT)

} GEN_SIN;

void GEN_SIN_init__(GEN_SIN *data__, BOOL retain);
// Code part
void GEN_SIN_body__(GEN_SIN *data__);
// FUNCTION_BLOCK GEN_PILA
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(INT,AMPLITUDE)
  __DECLARE_VAR(TIME,SPEED)
  __DECLARE_VAR(INT,OUT_INT)
  __DECLARE_VAR(REAL,OUT_REAL)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(BOOL,START)
  __DECLARE_VAR(BOOL,STOP)
  TON TON_0;
  TON TON_1;
  R_TRIG R_TRIG_0;
  __DECLARE_VAR(INT,AMP)
  R_TRIG R_TRIG_1;
  RS RS_0;
  R_TRIG R_TRIG_2;
  __DECLARE_VAR(BOOL,DIRECT)
  R_TRIG R_TRIG_3;
  __DECLARE_VAR(INT,_TMP_LIMIT85_OUT)
  __DECLARE_VAR(BOOL,_TMP_LE95_OUT)
  __DECLARE_VAR(BOOL,_TMP_EQ124_OUT)
  __DECLARE_VAR(BOOL,_TMP_OR125_OUT)
  __DECLARE_VAR(BOOL,_TMP_GE122_OUT)
  __DECLARE_VAR(BOOL,_TMP_EQ130_OUT)
  __DECLARE_VAR(BOOL,_TMP_OR128_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND96_OUT)
  __DECLARE_VAR(BOOL,_TMP_ADD58_ENO)
  __DECLARE_VAR(INT,_TMP_ADD58_OUT)
  __DECLARE_VAR(BOOL,_TMP_AND100_OUT)
  __DECLARE_VAR(BOOL,_TMP_SUB109_ENO)
  __DECLARE_VAR(INT,_TMP_SUB109_OUT)
  __DECLARE_VAR(REAL,_TMP_INT_TO_REAL110_OUT)

} GEN_PILA;

void GEN_PILA_init__(GEN_PILA *data__, BOOL retain);
// Code part
void GEN_PILA_body__(GEN_PILA *data__);
// PROGRAM DEMO_GENERATORS
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  GEN_SIN GEN_SIN_0;
  GEN_PILA GEN_PILA_0;
  GEN_CYCLIC GEN_CYCLIC_0;

} DEMO_GENERATORS;

void DEMO_GENERATORS_init__(DEMO_GENERATORS *data__, BOOL retain);
// Code part
void DEMO_GENERATORS_body__(DEMO_GENERATORS *data__);
// FUNCTION_BLOCK COM_STV900
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(WORD,RD1)
  __DECLARE_VAR(WORD,RD2)
  __DECLARE_VAR(WORD,RD3)
  __DECLARE_VAR(WORD,RD4)
  __DECLARE_VAR(WORD,RD5)
  __DECLARE_VAR(WORD,RD6)
  __DECLARE_VAR(WORD,RD7)
  __DECLARE_VAR(WORD,RD8)
  __DECLARE_VAR(WORD,RD9)
  __DECLARE_VAR(WORD,RD10)
  __DECLARE_VAR(WORD,RD11)
  __DECLARE_VAR(INT,CMD_CTRL)
  __DECLARE_VAR(REAL,CMD_SET_FREQ)
  __DECLARE_VAR(REAL,RUN_FREQ)
  __DECLARE_VAR(REAL,SET_FREQ)
  __DECLARE_VAR(REAL,BUS_VOLT)
  __DECLARE_VAR(INT,OUTPUT_VOLT)
  __DECLARE_VAR(REAL,OUTPUT_CUR)
  __DECLARE_VAR(INT,RUN_SPEED)
  __DECLARE_VAR(REAL,OUTPUT_PWR)
  __DECLARE_VAR(REAL,OUTPUT_TORQ)
  __DECLARE_VAR(INT,SW1)
  __DECLARE_VAR(WORD,SW2)
  __DECLARE_VAR(INT,FAULT_CODE)
  __DECLARE_VAR(WORD,WR1)
  __DECLARE_VAR(WORD,WR2)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,_TMP_WORD_TO_REAL1_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV3_OUT)
  __DECLARE_VAR(REAL,_TMP_WORD_TO_REAL10_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV7_OUT)
  __DECLARE_VAR(REAL,_TMP_WORD_TO_REAL16_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV13_OUT)
  __DECLARE_VAR(INT,_TMP_WORD_TO_INT42_OUT)
  __DECLARE_VAR(REAL,_TMP_WORD_TO_REAL35_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV23_OUT)
  __DECLARE_VAR(INT,_TMP_WORD_TO_INT41_OUT)
  __DECLARE_VAR(REAL,_TMP_WORD_TO_REAL45_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV46_OUT)
  __DECLARE_VAR(REAL,_TMP_WORD_TO_REAL55_OUT)
  __DECLARE_VAR(REAL,_TMP_DIV53_OUT)
  __DECLARE_VAR(INT,_TMP_WORD_TO_INT60_OUT)
  __DECLARE_VAR(INT,_TMP_WORD_TO_INT66_OUT)
  __DECLARE_VAR(WORD,_TMP_INT_TO_WORD73_OUT)
  __DECLARE_VAR(REAL,_TMP_MUL77_OUT)
  __DECLARE_VAR(WORD,_TMP_REAL_TO_WORD79_OUT)

} COM_STV900;

void COM_STV900_init__(COM_STV900 *data__, BOOL retain);
// Code part
void COM_STV900_body__(COM_STV900 *data__);
// PROGRAM DEMO_STV900
// Data part
typedef struct {
  // PROGRAM Interface - IN, OUT, IN_OUT variables

  // PROGRAM private variables - TEMP, private and located variables
  COM_STV900 COM_STV900_0;

} DEMO_STV900;

void DEMO_STV900_init__(DEMO_STV900 *data__, BOOL retain);
// Code part
void DEMO_STV900_body__(DEMO_STV900 *data__);
#endif //__POUS_H
