FUNCTION_BLOCK AI_SCALE
  VAR_INPUT
    AI_INP : INT;
    IN_MAX : REAL;
    IN_MIN : REAL;
    OUT_MAX : REAL;
    OUT_MIN : REAL;
  END_VAR
  VAR_OUTPUT
    AI_OUT : REAL;
  END_VAR
  VAR
    TEMP : REAL;
  END_VAR
  VAR_OUTPUT
    H_Lim : BOOL;
    L_Lim : BOOL;
  END_VAR
  VAR
    AI_OUT_Calc : REAL;
    _TMP_EQ84_OUT : BOOL;
    _TMP_SEL97_OUT : BOOL;
    _TMP_EQ98_OUT : BOOL;
    _TMP_SEL87_OUT : BOOL;
    _TMP_SUB2_OUT : REAL;
    _TMP_EQ12_OUT : BOOL;
    _TMP_NOT43_OUT : BOOL;
    _TMP_SEL10_OUT : REAL;
    _TMP_INT_TO_REAL47_OUT : REAL;
    _TMP_SUB45_OUT : REAL;
    _TMP_SUB46_OUT : REAL;
    _TMP_MUL52_OUT : REAL;
    _TMP_DIV56_OUT : REAL;
    _TMP_ADD60_OUT : REAL;
    _TMP_AND115_OUT : BOOL;
    _TMP_MOVE119_ENO : BOOL;
    _TMP_MOVE119_OUT : REAL;
    _TMP_AND125_OUT : BOOL;
    _TMP_MOVE121_ENO : BOOL;
    _TMP_MOVE121_OUT : REAL;
    _TMP_AND129_OUT : BOOL;
    _TMP_MOVE128_ENO : BOOL;
    _TMP_MOVE128_OUT : REAL;
  END_VAR

  _TMP_EQ84_OUT := EQ(AI_INP, 32767);(*FBD id[84]*)
  _TMP_SEL97_OUT := SEL(_TMP_EQ84_OUT, false, true);(*FBD id[97]*)
  H_Lim := _TMP_SEL97_OUT;(*FBD id[90]*)
  _TMP_EQ98_OUT := EQ(AI_INP, -32767);(*FBD id[98]*)
  _TMP_SEL87_OUT := SEL(_TMP_EQ98_OUT, false, true);(*FBD id[87]*)
  L_Lim := _TMP_SEL87_OUT;(*FBD id[89]*)
  _TMP_SUB2_OUT := SUB(IN_MAX, IN_MIN);(*FBD id[2]*)
  _TMP_EQ12_OUT := EQ(_TMP_SUB2_OUT, 0.0);(*FBD id[12]*)
  _TMP_NOT43_OUT := NOT(_TMP_EQ12_OUT);(*FBD id[43]*)
  _TMP_SEL10_OUT := SEL(_TMP_NOT43_OUT, 1.0, _TMP_SUB2_OUT);(*FBD id[10]*)
  TEMP := _TMP_SEL10_OUT;(*FBD id[16]*)
  _TMP_INT_TO_REAL47_OUT := INT_TO_REAL(AI_INP);(*FBD id[47]*)
  _TMP_SUB45_OUT := SUB(_TMP_INT_TO_REAL47_OUT, IN_MIN);(*FBD id[45]*)
  _TMP_SUB46_OUT := SUB(OUT_MAX, OUT_MIN);(*FBD id[46]*)
  _TMP_MUL52_OUT := MUL(_TMP_SUB45_OUT, _TMP_SUB46_OUT);(*FBD id[52]*)
  _TMP_DIV56_OUT := DIV(_TMP_MUL52_OUT, TEMP);(*FBD id[56]*)
  _TMP_ADD60_OUT := ADD(_TMP_DIV56_OUT, OUT_MIN);(*FBD id[60]*)
  AI_OUT_Calc := _TMP_ADD60_OUT;(*FBD id[57]*)
  _TMP_AND115_OUT := AND(H_Lim, NOT(L_Lim));(*FBD id[115]*)
  IF _TMP_AND115_OUT THEN
      _TMP_MOVE119_OUT := MOVE(IN := OUT_MAX, ENO => _TMP_MOVE119_ENO);(*FBD id[119]*)
  ELSE
    _TMP_MOVE119_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE119_ENO THEN
      AI_OUT := _TMP_MOVE119_OUT;(*FBD id[117]*)
  END_IF;
  _TMP_AND125_OUT := AND(NOT(H_Lim), L_Lim);(*FBD id[125]*)
  IF _TMP_AND125_OUT THEN
      _TMP_MOVE121_OUT := MOVE(IN := OUT_MIN, ENO => _TMP_MOVE121_ENO);(*FBD id[121]*)
  ELSE
    _TMP_MOVE121_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE121_ENO THEN
      AI_OUT := _TMP_MOVE121_OUT;(*FBD id[120]*)
  END_IF;
  _TMP_AND129_OUT := AND(NOT(H_Lim), NOT(L_Lim));(*FBD id[129]*)
  IF _TMP_AND129_OUT THEN
      _TMP_MOVE128_OUT := MOVE(IN := AI_OUT_Calc, ENO => _TMP_MOVE128_ENO);(*FBD id[128]*)
  ELSE
    _TMP_MOVE128_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE128_ENO THEN
      AI_OUT := _TMP_MOVE128_OUT;(*FBD id[131]*)
  END_IF;
END_FUNCTION_BLOCK

PROGRAM DEMO_AI_4_20mA
  VAR
    ADC_MAX : REAL;
    ADC_MIN : REAL;
    AI3_CUR : REAL;
    AI3_PHYS : REAL;
    AI3_PRC : REAL;
    AI3_H_Lim : BOOL;
    AI3_L_Lim : BOOL;
    CUR_SCALE : AI_SCALE;
    PRC_SCALE : AI_SCALE;
    PHYS_SCALE : AI_SCALE;
  END_VAR

  ADC_MAX := 32000.0;(*FBD id[21]*)
  ADC_MIN := 0.0;(*FBD id[26]*)
  CUR_SCALE(AI_INP := AI3, IN_MAX := ADC_MAX, IN_MIN := ADC_MIN, OUT_MAX := 20.0, OUT_MIN := 4.0);(*FBD id[126]*)
  AI3_CUR := CUR_SCALE.AI_OUT;(*FBD id[91]*)
  AI3_H_Lim := CUR_SCALE.H_Lim;(*FBD id[92]*)
  AI3_L_Lim := CUR_SCALE.L_Lim;(*FBD id[93]*)
  PRC_SCALE(AI_INP := AI3, IN_MAX := ADC_MAX, IN_MIN := ADC_MIN, OUT_MAX := 100.0, OUT_MIN := 0.0);(*FBD id[128]*)
  AI3_PRC := PRC_SCALE.AI_OUT;(*FBD id[112]*)
  PHYS_SCALE(AI_INP := AI3, IN_MAX := ADC_MAX, IN_MIN := ADC_MIN, OUT_MAX := 50.0, OUT_MIN := -50.0);(*FBD id[130]*)
  AI3_PHYS := PHYS_SCALE.AI_OUT;(*FBD id[97]*)
END_PROGRAM

PROGRAM DEMO_AI_0_20mA
  VAR
    ADC_MAX : REAL;
    ADC_MIN : REAL;
    AI2_CUR : REAL;
    AI2_PHYS : REAL;
    AI2_PRC : REAL;
    AI2_H_Lim : BOOL;
    CUR_SCALE : AI_SCALE;
    PRC_SCALE : AI_SCALE;
    PHYS_SCALE : AI_SCALE;
  END_VAR

  ADC_MAX := 32000.0;(*FBD id[21]*)
  ADC_MIN := 0.0;(*FBD id[26]*)
  CUR_SCALE(AI_INP := AI2, IN_MAX := ADC_MAX, IN_MIN := ADC_MIN, OUT_MAX := 20.0, OUT_MIN := 0.0);(*FBD id[122]*)
  AI2_CUR := CUR_SCALE.AI_OUT;(*FBD id[91]*)
  AI2_H_Lim := CUR_SCALE.H_Lim;(*FBD id[92]*)
  PRC_SCALE(AI_INP := AI2, IN_MAX := ADC_MAX, IN_MIN := ADC_MIN, OUT_MAX := 100.0, OUT_MIN := 0.0);(*FBD id[124]*)
  AI2_PRC := PRC_SCALE.AI_OUT;(*FBD id[112]*)
  PHYS_SCALE(AI_INP := AI2, IN_MAX := ADC_MAX, IN_MIN := ADC_MIN, OUT_MAX := 50.0, OUT_MIN := -50.0);(*FBD id[126]*)
  AI2_PHYS := PHYS_SCALE.AI_OUT;(*FBD id[97]*)
END_PROGRAM

PROGRAM DEMO_AI_0_10V
  VAR
    ADC_MAX : REAL;
    ADC_MIN : REAL;
    AI1_VOLT : REAL;
    AI1_H_Lim : BOOL;
    AI1_PHYS : REAL;
    AI1_PRC : REAL;
    VOLT_SCALE : AI_SCALE;
    PRC_SCALE : AI_SCALE;
    PHYS_SCALE : AI_SCALE;
  END_VAR

  ADC_MAX := 32000.0;(*FBD id[21]*)
  ADC_MIN := 0.0;(*FBD id[26]*)
  VOLT_SCALE(AI_INP := AI1, IN_MAX := ADC_MAX, IN_MIN := ADC_MIN, OUT_MAX := 10.0, OUT_MIN := 0.0);(*FBD id[122]*)
  AI1_VOLT := VOLT_SCALE.AI_OUT;(*FBD id[91]*)
  AI1_H_Lim := VOLT_SCALE.H_Lim;(*FBD id[92]*)
  PRC_SCALE(AI_INP := AI1, IN_MAX := ADC_MAX, IN_MIN := ADC_MIN, OUT_MAX := 100.0, OUT_MIN := 0.0);(*FBD id[124]*)
  AI1_PRC := PRC_SCALE.AI_OUT;(*FBD id[112]*)
  PHYS_SCALE(AI_INP := AI1, IN_MAX := ADC_MAX, IN_MIN := ADC_MIN, OUT_MAX := 50.0, OUT_MIN := -50.0);(*FBD id[126]*)
  AI1_PHYS := PHYS_SCALE.AI_OUT;(*FBD id[97]*)
END_PROGRAM

FUNCTION_BLOCK AI_PT100_SCALE
  VAR_INPUT
    AI_INP : INT;
  END_VAR
  VAR_OUTPUT
    AI_OUT : REAL;
  END_VAR
  VAR
    TEMP : REAL;
  END_VAR
  VAR_OUTPUT
    H_Lim : BOOL;
    L_Lim : BOOL;
  END_VAR
  VAR
    AI_OUT_Calc : REAL;
    _TMP_EQ84_OUT : BOOL;
    _TMP_SEL97_OUT : BOOL;
    _TMP_EQ98_OUT : BOOL;
    _TMP_SEL87_OUT : BOOL;
    _TMP_SUB2_OUT : REAL;
    _TMP_INT_TO_REAL47_OUT : REAL;
    _TMP_SUB45_OUT : REAL;
    _TMP_SUB46_OUT : REAL;
    _TMP_MUL52_OUT : REAL;
    _TMP_DIV56_OUT : REAL;
    _TMP_ADD60_OUT : REAL;
    _TMP_AND115_OUT : BOOL;
    _TMP_MOVE119_ENO : BOOL;
    _TMP_MOVE119_OUT : REAL;
    _TMP_AND125_OUT : BOOL;
    _TMP_MOVE121_ENO : BOOL;
    _TMP_MOVE121_OUT : REAL;
    _TMP_AND129_OUT : BOOL;
    _TMP_MOVE128_ENO : BOOL;
    _TMP_MOVE128_OUT : REAL;
  END_VAR

  _TMP_EQ84_OUT := EQ(AI_INP, 32767);(*FBD id[84]*)
  _TMP_SEL97_OUT := SEL(_TMP_EQ84_OUT, false, true);(*FBD id[97]*)
  H_Lim := _TMP_SEL97_OUT;(*FBD id[90]*)
  _TMP_EQ98_OUT := EQ(AI_INP, -32767);(*FBD id[98]*)
  _TMP_SEL87_OUT := SEL(_TMP_EQ98_OUT, false, true);(*FBD id[87]*)
  L_Lim := _TMP_SEL87_OUT;(*FBD id[89]*)
  _TMP_SUB2_OUT := SUB(8500.0, -1000.0);(*FBD id[2]*)
  TEMP := _TMP_SUB2_OUT;(*FBD id[16]*)
  _TMP_INT_TO_REAL47_OUT := INT_TO_REAL(AI_INP);(*FBD id[47]*)
  _TMP_SUB45_OUT := SUB(_TMP_INT_TO_REAL47_OUT, -1000.0);(*FBD id[45]*)
  _TMP_SUB46_OUT := SUB(850.0, -100.0);(*FBD id[46]*)
  _TMP_MUL52_OUT := MUL(_TMP_SUB45_OUT, _TMP_SUB46_OUT);(*FBD id[52]*)
  _TMP_DIV56_OUT := DIV(_TMP_MUL52_OUT, TEMP);(*FBD id[56]*)
  _TMP_ADD60_OUT := ADD(_TMP_DIV56_OUT, -100.0);(*FBD id[60]*)
  AI_OUT_Calc := _TMP_ADD60_OUT;(*FBD id[57]*)
  _TMP_AND115_OUT := AND(H_Lim, NOT(L_Lim));(*FBD id[115]*)
  IF _TMP_AND115_OUT THEN
      _TMP_MOVE119_OUT := MOVE(IN := 850.0, ENO => _TMP_MOVE119_ENO);(*FBD id[119]*)
  ELSE
    _TMP_MOVE119_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE119_ENO THEN
      AI_OUT := _TMP_MOVE119_OUT;(*FBD id[117]*)
  END_IF;
  _TMP_AND125_OUT := AND(NOT(H_Lim), L_Lim);(*FBD id[125]*)
  IF _TMP_AND125_OUT THEN
      _TMP_MOVE121_OUT := MOVE(IN := -200.0, ENO => _TMP_MOVE121_ENO);(*FBD id[121]*)
  ELSE
    _TMP_MOVE121_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE121_ENO THEN
      AI_OUT := _TMP_MOVE121_OUT;(*FBD id[120]*)
  END_IF;
  _TMP_AND129_OUT := AND(NOT(H_Lim), NOT(L_Lim));(*FBD id[129]*)
  IF _TMP_AND129_OUT THEN
      _TMP_MOVE128_OUT := MOVE(IN := AI_OUT_Calc, ENO => _TMP_MOVE128_ENO);(*FBD id[128]*)
  ELSE
    _TMP_MOVE128_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE128_ENO THEN
      AI_OUT := _TMP_MOVE128_OUT;(*FBD id[131]*)
  END_IF;
END_FUNCTION_BLOCK

PROGRAM DEMO_AI_PT100
  VAR
    AI5_PT100 : REAL;
    AI5_H_Lim : BOOL;
    AI5_L_Lim : BOOL;
    PT100_SCALE : AI_PT100_SCALE;
  END_VAR

  PT100_SCALE(AI_INP := AI5);(*FBD id[118]*)
  AI5_PT100 := PT100_SCALE.AI_OUT;(*FBD id[91]*)
  AI5_H_Lim := PT100_SCALE.H_Lim;(*FBD id[92]*)
  AI5_L_Lim := PT100_SCALE.L_Lim;(*FBD id[93]*)
END_PROGRAM

FUNCTION_BLOCK AI_PT1000_SCALE
  VAR_INPUT
    AI_INP : INT;
  END_VAR
  VAR_OUTPUT
    AI_OUT : REAL;
  END_VAR
  VAR
    TEMP : REAL;
  END_VAR
  VAR_OUTPUT
    H_Lim : BOOL;
    L_Lim : BOOL;
  END_VAR
  VAR
    AI_OUT_Calc : REAL;
    _TMP_EQ84_OUT : BOOL;
    _TMP_SEL97_OUT : BOOL;
    _TMP_EQ98_OUT : BOOL;
    _TMP_SEL87_OUT : BOOL;
    _TMP_SUB2_OUT : REAL;
    _TMP_INT_TO_REAL47_OUT : REAL;
    _TMP_SUB45_OUT : REAL;
    _TMP_SUB46_OUT : REAL;
    _TMP_MUL52_OUT : REAL;
    _TMP_DIV56_OUT : REAL;
    _TMP_ADD60_OUT : REAL;
    _TMP_AND115_OUT : BOOL;
    _TMP_MOVE119_ENO : BOOL;
    _TMP_MOVE119_OUT : REAL;
    _TMP_AND125_OUT : BOOL;
    _TMP_MOVE121_ENO : BOOL;
    _TMP_MOVE121_OUT : REAL;
    _TMP_AND129_OUT : BOOL;
    _TMP_MOVE128_ENO : BOOL;
    _TMP_MOVE128_OUT : REAL;
  END_VAR

  _TMP_EQ84_OUT := EQ(AI_INP, 32767);(*FBD id[84]*)
  _TMP_SEL97_OUT := SEL(_TMP_EQ84_OUT, false, true);(*FBD id[97]*)
  H_Lim := _TMP_SEL97_OUT;(*FBD id[90]*)
  _TMP_EQ98_OUT := EQ(AI_INP, -32767);(*FBD id[98]*)
  _TMP_SEL87_OUT := SEL(_TMP_EQ98_OUT, false, true);(*FBD id[87]*)
  L_Lim := _TMP_SEL87_OUT;(*FBD id[89]*)
  _TMP_SUB2_OUT := SUB(8500.0, -1000.0);(*FBD id[2]*)
  TEMP := _TMP_SUB2_OUT;(*FBD id[16]*)
  _TMP_INT_TO_REAL47_OUT := INT_TO_REAL(AI_INP);(*FBD id[47]*)
  _TMP_SUB45_OUT := SUB(_TMP_INT_TO_REAL47_OUT, -1000.0);(*FBD id[45]*)
  _TMP_SUB46_OUT := SUB(850.0, -100.0);(*FBD id[46]*)
  _TMP_MUL52_OUT := MUL(_TMP_SUB45_OUT, _TMP_SUB46_OUT);(*FBD id[52]*)
  _TMP_DIV56_OUT := DIV(_TMP_MUL52_OUT, TEMP);(*FBD id[56]*)
  _TMP_ADD60_OUT := ADD(_TMP_DIV56_OUT, -100.0);(*FBD id[60]*)
  AI_OUT_Calc := _TMP_ADD60_OUT;(*FBD id[57]*)
  _TMP_AND115_OUT := AND(H_Lim, NOT(L_Lim));(*FBD id[115]*)
  IF _TMP_AND115_OUT THEN
      _TMP_MOVE119_OUT := MOVE(IN := 850.0, ENO => _TMP_MOVE119_ENO);(*FBD id[119]*)
  ELSE
    _TMP_MOVE119_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE119_ENO THEN
      AI_OUT := _TMP_MOVE119_OUT;(*FBD id[117]*)
  END_IF;
  _TMP_AND125_OUT := AND(NOT(H_Lim), L_Lim);(*FBD id[125]*)
  IF _TMP_AND125_OUT THEN
      _TMP_MOVE121_OUT := MOVE(IN := -200.0, ENO => _TMP_MOVE121_ENO);(*FBD id[121]*)
  ELSE
    _TMP_MOVE121_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE121_ENO THEN
      AI_OUT := _TMP_MOVE121_OUT;(*FBD id[120]*)
  END_IF;
  _TMP_AND129_OUT := AND(NOT(H_Lim), NOT(L_Lim));(*FBD id[129]*)
  IF _TMP_AND129_OUT THEN
      _TMP_MOVE128_OUT := MOVE(IN := AI_OUT_Calc, ENO => _TMP_MOVE128_ENO);(*FBD id[128]*)
  ELSE
    _TMP_MOVE128_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE128_ENO THEN
      AI_OUT := _TMP_MOVE128_OUT;(*FBD id[131]*)
  END_IF;
END_FUNCTION_BLOCK

PROGRAM DEMO_AI_PT1000
  VAR
    AI6_PT1000 : REAL;
    AI6_H_Lim : BOOL;
    AI6_L_Lim : BOOL;
    PT1000_SCALE : AI_PT1000_SCALE;
  END_VAR

  PT1000_SCALE(AI_INP := AI6);(*FBD id[120]*)
  AI6_PT1000 := PT1000_SCALE.AI_OUT;(*FBD id[91]*)
  AI6_H_Lim := PT1000_SCALE.H_Lim;(*FBD id[92]*)
  AI6_L_Lim := PT1000_SCALE.L_Lim;(*FBD id[93]*)
END_PROGRAM

FUNCTION_BLOCK AI_RTD_SCALE
  VAR_INPUT
    AI_INP : INT;
  END_VAR
  VAR_OUTPUT
    AI_OUT : REAL;
  END_VAR
  VAR
    TEMP : REAL;
  END_VAR
  VAR_OUTPUT
    H_Lim : BOOL;
    L_Lim : BOOL;
  END_VAR
  VAR
    AI_OUT_Calc : REAL;
    _TMP_EQ84_OUT : BOOL;
    _TMP_SEL97_OUT : BOOL;
    _TMP_EQ98_OUT : BOOL;
    _TMP_SEL87_OUT : BOOL;
    _TMP_SUB2_OUT : REAL;
    _TMP_INT_TO_REAL47_OUT : REAL;
    _TMP_SUB45_OUT : REAL;
    _TMP_SUB46_OUT : REAL;
    _TMP_MUL52_OUT : REAL;
    _TMP_DIV56_OUT : REAL;
    _TMP_ADD60_OUT : REAL;
    _TMP_AND115_OUT : BOOL;
    _TMP_MOVE119_ENO : BOOL;
    _TMP_MOVE119_OUT : REAL;
    _TMP_AND125_OUT : BOOL;
    _TMP_MOVE121_ENO : BOOL;
    _TMP_MOVE121_OUT : REAL;
    _TMP_AND129_OUT : BOOL;
    _TMP_MOVE128_ENO : BOOL;
    _TMP_MOVE128_OUT : REAL;
  END_VAR

  _TMP_EQ84_OUT := EQ(AI_INP, 32767);(*FBD id[84]*)
  _TMP_SEL97_OUT := SEL(_TMP_EQ84_OUT, false, true);(*FBD id[97]*)
  H_Lim := _TMP_SEL97_OUT;(*FBD id[90]*)
  _TMP_EQ98_OUT := EQ(AI_INP, -32767);(*FBD id[98]*)
  _TMP_SEL87_OUT := SEL(_TMP_EQ98_OUT, false, true);(*FBD id[87]*)
  L_Lim := _TMP_SEL87_OUT;(*FBD id[89]*)
  _TMP_SUB2_OUT := SUB(32000.0, 100.0);(*FBD id[2]*)
  TEMP := _TMP_SUB2_OUT;(*FBD id[16]*)
  _TMP_INT_TO_REAL47_OUT := INT_TO_REAL(AI_INP);(*FBD id[47]*)
  _TMP_SUB45_OUT := SUB(_TMP_INT_TO_REAL47_OUT, 100.0);(*FBD id[45]*)
  _TMP_SUB46_OUT := SUB(32000.0, 100.0);(*FBD id[46]*)
  _TMP_MUL52_OUT := MUL(_TMP_SUB45_OUT, _TMP_SUB46_OUT);(*FBD id[52]*)
  _TMP_DIV56_OUT := DIV(_TMP_MUL52_OUT, TEMP);(*FBD id[56]*)
  _TMP_ADD60_OUT := ADD(_TMP_DIV56_OUT, 100.0);(*FBD id[60]*)
  AI_OUT_Calc := _TMP_ADD60_OUT;(*FBD id[57]*)
  _TMP_AND115_OUT := AND(H_Lim, NOT(L_Lim));(*FBD id[115]*)
  IF _TMP_AND115_OUT THEN
      _TMP_MOVE119_OUT := MOVE(IN := 32000.0, ENO => _TMP_MOVE119_ENO);(*FBD id[119]*)
  ELSE
    _TMP_MOVE119_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE119_ENO THEN
      AI_OUT := _TMP_MOVE119_OUT;(*FBD id[117]*)
  END_IF;
  _TMP_AND125_OUT := AND(NOT(H_Lim), L_Lim);(*FBD id[125]*)
  IF _TMP_AND125_OUT THEN
      _TMP_MOVE121_OUT := MOVE(IN := 100.0, ENO => _TMP_MOVE121_ENO);(*FBD id[121]*)
  ELSE
    _TMP_MOVE121_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE121_ENO THEN
      AI_OUT := _TMP_MOVE121_OUT;(*FBD id[120]*)
  END_IF;
  _TMP_AND129_OUT := AND(NOT(H_Lim), NOT(L_Lim));(*FBD id[129]*)
  IF _TMP_AND129_OUT THEN
      _TMP_MOVE128_OUT := MOVE(IN := AI_OUT_Calc, ENO => _TMP_MOVE128_ENO);(*FBD id[128]*)
  ELSE
    _TMP_MOVE128_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE128_ENO THEN
      AI_OUT := _TMP_MOVE128_OUT;(*FBD id[131]*)
  END_IF;
END_FUNCTION_BLOCK

PROGRAM DEMO_AI_RTD
  VAR
    AI7_RTD : REAL;
    AI7_H_Lim : BOOL;
    AI7_L_Lim : BOOL;
    AI_RTD_0 : AI_RTD_SCALE;
  END_VAR

  AI_RTD_0(AI_INP := AI7);(*FBD id[120]*)
  AI7_RTD := AI_RTD_0.AI_OUT;(*FBD id[91]*)
  AI7_H_Lim := AI_RTD_0.H_Lim;(*FBD id[92]*)
  AI7_L_Lim := AI_RTD_0.L_Lim;(*FBD id[93]*)
END_PROGRAM

FUNCTION_BLOCK AO_SCALE
  VAR_INPUT
    INP_SIGNAL : REAL;
    DAC_MAX : REAL;
    DAC_MIN : REAL;
  END_VAR
  VAR_OUTPUT
    AO_OUT : INT;
  END_VAR
  VAR
    TEMP : REAL;
  END_VAR
  VAR_OUTPUT
    H_Lim : BOOL;
    L_Lim : BOOL;
  END_VAR
  VAR
    AO_OUT_Calc : REAL;
    _TMP_GT133_OUT : BOOL;
    _TMP_SEL97_OUT : BOOL;
    _TMP_LT134_OUT : BOOL;
    _TMP_SEL87_OUT : BOOL;
    _TMP_SUB2_OUT : REAL;
    _TMP_SUB45_OUT : REAL;
    _TMP_SUB46_OUT : REAL;
    _TMP_MUL52_OUT : REAL;
    _TMP_DIV56_OUT : REAL;
    _TMP_ADD60_OUT : REAL;
    _TMP_AND115_OUT : BOOL;
    _TMP_MOVE119_ENO : BOOL;
    _TMP_MOVE119_OUT : REAL;
    _TMP_REAL_TO_INT138_ENO : BOOL;
    _TMP_REAL_TO_INT138_OUT : INT;
    _TMP_AND125_OUT : BOOL;
    _TMP_MOVE121_ENO : BOOL;
    _TMP_MOVE121_OUT : REAL;
    _TMP_REAL_TO_INT139_ENO : BOOL;
    _TMP_REAL_TO_INT139_OUT : INT;
    _TMP_AND129_OUT : BOOL;
    _TMP_MOVE128_ENO : BOOL;
    _TMP_MOVE128_OUT : REAL;
    _TMP_REAL_TO_INT140_ENO : BOOL;
    _TMP_REAL_TO_INT140_OUT : INT;
  END_VAR

  _TMP_GT133_OUT := GT(INP_SIGNAL, 100.0);(*FBD id[133]*)
  _TMP_SEL97_OUT := SEL(_TMP_GT133_OUT, false, true);(*FBD id[97]*)
  H_Lim := _TMP_SEL97_OUT;(*FBD id[90]*)
  _TMP_LT134_OUT := LT(INP_SIGNAL, 0.0);(*FBD id[134]*)
  _TMP_SEL87_OUT := SEL(_TMP_LT134_OUT, false, true);(*FBD id[87]*)
  L_Lim := _TMP_SEL87_OUT;(*FBD id[89]*)
  _TMP_SUB2_OUT := SUB(100.0, 0.0);(*FBD id[2]*)
  TEMP := _TMP_SUB2_OUT;(*FBD id[16]*)
  _TMP_SUB45_OUT := SUB(INP_SIGNAL, 0.0);(*FBD id[45]*)
  _TMP_SUB46_OUT := SUB(DAC_MAX, DAC_MIN);(*FBD id[46]*)
  _TMP_MUL52_OUT := MUL(_TMP_SUB45_OUT, _TMP_SUB46_OUT);(*FBD id[52]*)
  _TMP_DIV56_OUT := DIV(_TMP_MUL52_OUT, TEMP);(*FBD id[56]*)
  _TMP_ADD60_OUT := ADD(_TMP_DIV56_OUT, DAC_MIN);(*FBD id[60]*)
  AO_OUT_Calc := _TMP_ADD60_OUT;(*FBD id[57]*)
  _TMP_AND115_OUT := AND(H_Lim, NOT(L_Lim));(*FBD id[115]*)
  IF _TMP_AND115_OUT THEN
      _TMP_MOVE119_OUT := MOVE(IN := DAC_MAX, ENO => _TMP_MOVE119_ENO);(*FBD id[119]*)
  ELSE
    _TMP_MOVE119_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE119_ENO THEN
      _TMP_REAL_TO_INT138_OUT := REAL_TO_INT(IN := _TMP_MOVE119_OUT, ENO => _TMP_REAL_TO_INT138_ENO);(*FBD id[138]*)
  ELSE
    _TMP_REAL_TO_INT138_ENO := FALSE;
  END_IF;
  IF _TMP_REAL_TO_INT138_ENO THEN
      AO_OUT := _TMP_REAL_TO_INT138_OUT;(*FBD id[117]*)
  END_IF;
  _TMP_AND125_OUT := AND(NOT(H_Lim), L_Lim);(*FBD id[125]*)
  IF _TMP_AND125_OUT THEN
      _TMP_MOVE121_OUT := MOVE(IN := DAC_MIN, ENO => _TMP_MOVE121_ENO);(*FBD id[121]*)
  ELSE
    _TMP_MOVE121_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE121_ENO THEN
      _TMP_REAL_TO_INT139_OUT := REAL_TO_INT(IN := _TMP_MOVE121_OUT, ENO => _TMP_REAL_TO_INT139_ENO);(*FBD id[139]*)
  ELSE
    _TMP_REAL_TO_INT139_ENO := FALSE;
  END_IF;
  IF _TMP_REAL_TO_INT139_ENO THEN
      AO_OUT := _TMP_REAL_TO_INT139_OUT;(*FBD id[120]*)
  END_IF;
  _TMP_AND129_OUT := AND(NOT(H_Lim), NOT(L_Lim));(*FBD id[129]*)
  IF _TMP_AND129_OUT THEN
      _TMP_MOVE128_OUT := MOVE(IN := AO_OUT_Calc, ENO => _TMP_MOVE128_ENO);(*FBD id[128]*)
  ELSE
    _TMP_MOVE128_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE128_ENO THEN
      _TMP_REAL_TO_INT140_OUT := REAL_TO_INT(IN := _TMP_MOVE128_OUT, ENO => _TMP_REAL_TO_INT140_ENO);(*FBD id[140]*)
  ELSE
    _TMP_REAL_TO_INT140_ENO := FALSE;
  END_IF;
  IF _TMP_REAL_TO_INT140_ENO THEN
      AO_OUT := _TMP_REAL_TO_INT140_OUT;(*FBD id[131]*)
  END_IF;
END_FUNCTION_BLOCK

PROGRAM DEMO_AO_0_10V
  VAR
    INPUT_SIGNAL : REAL;
    AO1_H_Lim : BOOL;
    AO1_L_Lim : BOOL;
    AO_VOLT_DAC_0 : AO_SCALE;
    SET : REAL;
  END_VAR

  AO_VOLT_DAC_0(INP_SIGNAL := SET, DAC_MAX := 32000.0, DAC_MIN := 0.0);(*FBD id[148]*)
  AO1 := AO_VOLT_DAC_0.AO_OUT;(*FBD id[124]*)
  AO1_H_Lim := AO_VOLT_DAC_0.H_Lim;(*FBD id[129]*)
  AO1_L_Lim := AO_VOLT_DAC_0.L_Lim;(*FBD id[130]*)
END_PROGRAM

PROGRAM DEMO_AO_4_20mA
  VAR
    AO3_H_Lim : BOOL;
    AO3_L_Lim : BOOL;
    AO_CUR_DAC_0 : AO_SCALE;
    SET : REAL;
  END_VAR

  AO_CUR_DAC_0(INP_SIGNAL := SET, DAC_MAX := 32000.0, DAC_MIN := 0.0);(*FBD id[133]*)
  AO3 := AO_CUR_DAC_0.AO_OUT;(*FBD id[124]*)
  AO3_H_Lim := AO_CUR_DAC_0.H_Lim;(*FBD id[129]*)
  AO3_L_Lim := AO_CUR_DAC_0.L_Lim;(*FBD id[130]*)
END_PROGRAM

FUNCTION_BLOCK DO_On_Off
  VAR_INPUT
    INP_DI : BOOL;
    Timer_ON : INT;
    Timer_OFF : INT;
  END_VAR
  VAR_OUTPUT
    OUT_DO : BOOL;
    ET_Timer_ON : INT;
    ET_Timer_OFF : INT;
  END_VAR
  VAR
    Start : BOOL;
    Stop : BOOL;
    TON_0 : TON;
    TON_1 : TON;
    t_Timer_ON : TIME;
    t_Timer_OFF : TIME;
    RS_0 : RS;
    RS_1 : RS;
    _TMP_MUL8_OUT : INT;
    _TMP_INT_TO_TIME2_OUT : TIME;
    _TMP_MUL47_OUT : INT;
    _TMP_INT_TO_TIME45_OUT : TIME;
    _TMP_SUB_TIME39_OUT : TIME;
    _TMP_TIME_TO_INT28_OUT : INT;
    _TMP_DIV38_OUT : INT;
    _TMP_SUB_TIME50_OUT : TIME;
    _TMP_TIME_TO_INT36_OUT : INT;
    _TMP_DIV53_OUT : INT;
  END_VAR

  _TMP_MUL8_OUT := MUL(Timer_ON, 1000);(*FBD id[8]*)
  _TMP_INT_TO_TIME2_OUT := INT_TO_TIME(_TMP_MUL8_OUT);(*FBD id[2]*)
  t_Timer_ON := _TMP_INT_TO_TIME2_OUT;(*FBD id[41]*)
  _TMP_MUL47_OUT := MUL(Timer_OFF, 1000);(*FBD id[47]*)
  _TMP_INT_TO_TIME45_OUT := INT_TO_TIME(_TMP_MUL47_OUT);(*FBD id[45]*)
  t_Timer_OFF := _TMP_INT_TO_TIME45_OUT;(*FBD id[46]*)
  RS_0(S := INP_DI, R1 := Stop);(*FBD id[54]*)
  TON_0(IN := RS_0.Q1, PT := t_Timer_ON);(*FBD id[32]*)
  Start := TON_0.Q;(*FBD id[11]*)
  _TMP_SUB_TIME39_OUT := SUB_TIME(t_Timer_ON, TON_0.ET);(*FBD id[39]*)
  _TMP_TIME_TO_INT28_OUT := TIME_TO_INT(_TMP_SUB_TIME39_OUT);(*FBD id[28]*)
  _TMP_DIV38_OUT := DIV(_TMP_TIME_TO_INT28_OUT, 1000);(*FBD id[38]*)
  ET_Timer_ON := _TMP_DIV38_OUT;(*FBD id[6]*)
  TON_1(IN := Start, PT := t_Timer_OFF);(*FBD id[33]*)
  Stop := TON_1.Q;(*FBD id[22]*)
  _TMP_SUB_TIME50_OUT := SUB_TIME(t_Timer_OFF, TON_1.ET);(*FBD id[50]*)
  _TMP_TIME_TO_INT36_OUT := TIME_TO_INT(_TMP_SUB_TIME50_OUT);(*FBD id[36]*)
  _TMP_DIV53_OUT := DIV(_TMP_TIME_TO_INT36_OUT, 1000);(*FBD id[53]*)
  ET_Timer_OFF := _TMP_DIV53_OUT;(*FBD id[23]*)
  RS_1(S := Start, R1 := Stop);(*FBD id[55]*)
  OUT_DO := RS_1.Q1;(*FBD id[27]*)
END_FUNCTION_BLOCK

PROGRAM DEMO_DI_DO
  VAR
    DO_On_Off_0 : DO_On_Off;
    DO_On_Off_1 : DO_On_Off;
    _TMP_OR2_OUT : BOOL;
    _TMP_OR19_OUT : BOOL;
  END_VAR

  _TMP_OR2_OUT := OR(DI1, KEY1);(*FBD id[2]*)
  DO_On_Off_0(INP_DI := _TMP_OR2_OUT, Timer_ON := 5, Timer_OFF := 10);(*FBD id[15]*)
  DO1 := DO_On_Off_0.OUT_DO;(*FBD id[5]*)
  _TMP_OR19_OUT := OR(DI2, KEY2);(*FBD id[19]*)
  DO_On_Off_1(INP_DI := _TMP_OR19_OUT, Timer_ON := 10, Timer_OFF := 5);(*FBD id[16]*)
  DO2 := DO_On_Off_1.OUT_DO;(*FBD id[22]*)
END_PROGRAM

FUNCTION_BLOCK Timer_Counter
  VAR_OUTPUT
    BLINK : BOOL;
  END_VAR
  VAR
    Start : BOOL;
    Stop : BOOL;
    TON_0 : TON;
    TON_1 : TON;
    RS_0 : RS;
    RS_1 : RS;
  END_VAR
  VAR_OUTPUT
    Counter : INT;
  END_VAR
  VAR
    R_0 : R_TRIG;
    _TMP_ADD58_ENO : BOOL;
    _TMP_ADD58_OUT : INT;
    _TMP_GT75_OUT : BOOL;
    _TMP_MOVE67_ENO : BOOL;
    _TMP_MOVE67_OUT : INT;
  END_VAR

  TON_0(IN := NOT(Stop), PT := t#1s);(*FBD id[32]*)
  Start := TON_0.Q;(*FBD id[11]*)
  TON_1(IN := Start, PT := t#1s);(*FBD id[33]*)
  Stop := TON_1.Q;(*FBD id[22]*)
  RS_1(S := Start, R1 := Stop);(*FBD id[55]*)
  BLINK := RS_1.Q1;(*FBD id[27]*)
  R_0(CLK := Start);(*FBD id[56]*)
  IF R_0.Q THEN
      _TMP_ADD58_OUT := ADD(IN1 := Counter, IN2 := 1, ENO => _TMP_ADD58_ENO);(*FBD id[58]*)
  ELSE
    _TMP_ADD58_ENO := FALSE;
  END_IF;
  IF _TMP_ADD58_ENO THEN
      Counter := _TMP_ADD58_OUT;(*FBD id[60]*)
  END_IF;
  _TMP_GT75_OUT := GT(Counter, 255);(*FBD id[75]*)
  IF _TMP_GT75_OUT THEN
      _TMP_MOVE67_OUT := MOVE(IN := 0, ENO => _TMP_MOVE67_ENO);(*FBD id[67]*)
  ELSE
    _TMP_MOVE67_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE67_ENO THEN
      Counter := _TMP_MOVE67_OUT;(*FBD id[72]*)
  END_IF;
END_FUNCTION_BLOCK

PROGRAM DEMO_Timer_Counter
  VAR
    Timer_Counter_0 : Timer_Counter;
  END_VAR

  Timer_Counter_0();(*FBD id[22]*)
END_PROGRAM

FUNCTION_BLOCK Gen_Cyclic
  VAR
    Start : BOOL;
    Stop : BOOL;
    TON_0 : TON;
    TON_1 : TON;
    RS_0 : RS;
  END_VAR
  VAR_OUTPUT
    OUT_INT : INT;
  END_VAR
  VAR
    R_0 : R_TRIG;
  END_VAR
  VAR_INPUT
    Amplitude : INT;
  END_VAR
  VAR
    Amp : INT;
  END_VAR
  VAR_INPUT
    Speed : TIME;
  END_VAR
  VAR
    _TMP_LIMIT85_OUT : INT;
    _TMP_ADD58_ENO : BOOL;
    _TMP_ADD58_OUT : INT;
    _TMP_GT91_OUT : BOOL;
    _TMP_MOVE67_ENO : BOOL;
    _TMP_MOVE67_OUT : INT;
  END_VAR

  _TMP_LIMIT85_OUT := LIMIT(0, Amplitude, 32767);(*FBD id[85]*)
  Amp := _TMP_LIMIT85_OUT;(*FBD id[88]*)
  TON_0(IN := NOT(Stop), PT := Speed);(*FBD id[32]*)
  Start := TON_0.Q;(*FBD id[11]*)
  TON_1(IN := Start, PT := Speed);(*FBD id[33]*)
  Stop := TON_1.Q;(*FBD id[22]*)
  R_0(CLK := Start);(*FBD id[56]*)
  IF R_0.Q THEN
      _TMP_ADD58_OUT := ADD(IN1 := OUT_INT, IN2 := 1, ENO => _TMP_ADD58_ENO);(*FBD id[58]*)
  ELSE
    _TMP_ADD58_ENO := FALSE;
  END_IF;
  IF _TMP_ADD58_ENO THEN
      OUT_INT := _TMP_ADD58_OUT;(*FBD id[92]*)
  END_IF;
  _TMP_GT91_OUT := GT(OUT_INT, Amp);(*FBD id[91]*)
  IF _TMP_GT91_OUT THEN
      _TMP_MOVE67_OUT := MOVE(IN := 0, ENO => _TMP_MOVE67_ENO);(*FBD id[67]*)
  ELSE
    _TMP_MOVE67_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE67_ENO THEN
      OUT_INT := _TMP_MOVE67_OUT;(*FBD id[95]*)
  END_IF;
END_FUNCTION_BLOCK

FUNCTION_BLOCK Gen_SIN
  VAR
    Start : BOOL;
    Stop : BOOL;
    TON_0 : TON;
    TON_1 : TON;
    RS_0 : RS;
    Counter_INT : INT;
    R_TRIG_0 : R_TRIG;
  END_VAR
  VAR_INPUT
    Amplitude : INT;
  END_VAR
  VAR
    Amp : INT;
    Speed : TIME := t#20ms;
    Shift : INT := 1;
  END_VAR
  VAR_OUTPUT
    OUT_SIN : REAL;
  END_VAR
  VAR
    _TMP_LIMIT85_OUT : INT;
    _TMP_ADD58_ENO : BOOL;
    _TMP_ADD58_OUT : INT;
    _TMP_GE66_OUT : BOOL;
    _TMP_MOVE67_ENO : BOOL;
    _TMP_MOVE67_OUT : INT;
    _TMP_INT_TO_REAL96_OUT : REAL;
    _TMP_DIV97_OUT : REAL;
    _TMP_SIN99_OUT : REAL;
    _TMP_INT_TO_REAL108_OUT : REAL;
    _TMP_DIV110_OUT : REAL;
    _TMP_MUL100_OUT : REAL;
    _TMP_ADD101_OUT : REAL;
  END_VAR

  _TMP_LIMIT85_OUT := LIMIT(0, Amplitude, 32767);(*FBD id[85]*)
  Amp := _TMP_LIMIT85_OUT;(*FBD id[88]*)
  TON_0(IN := NOT(Stop), PT := Speed);(*FBD id[32]*)
  Start := TON_0.Q;(*FBD id[11]*)
  TON_1(IN := Start, PT := Speed);(*FBD id[33]*)
  Stop := TON_1.Q;(*FBD id[22]*)
  R_TRIG_0(CLK := Start);(*FBD id[56]*)
  IF R_TRIG_0.Q THEN
      _TMP_ADD58_OUT := ADD(IN1 := Counter_INT, IN2 := 1, ENO => _TMP_ADD58_ENO);(*FBD id[58]*)
  ELSE
    _TMP_ADD58_ENO := FALSE;
  END_IF;
  IF _TMP_ADD58_ENO THEN
      Counter_INT := _TMP_ADD58_OUT;(*FBD id[60]*)
  END_IF;
  _TMP_GE66_OUT := GE(Counter_INT, 628);(*FBD id[66]*)
  IF _TMP_GE66_OUT THEN
      _TMP_MOVE67_OUT := MOVE(IN := 0, ENO => _TMP_MOVE67_ENO);(*FBD id[67]*)
  ELSE
    _TMP_MOVE67_ENO := FALSE;
  END_IF;
  IF _TMP_MOVE67_ENO THEN
      Counter_INT := _TMP_MOVE67_OUT;(*FBD id[72]*)
  END_IF;
  _TMP_INT_TO_REAL96_OUT := INT_TO_REAL(Counter_INT);(*FBD id[96]*)
  _TMP_DIV97_OUT := DIV(_TMP_INT_TO_REAL96_OUT, 100.0);(*FBD id[97]*)
  _TMP_SIN99_OUT := SIN(_TMP_DIV97_OUT);(*FBD id[99]*)
  _TMP_INT_TO_REAL108_OUT := INT_TO_REAL(Amp);(*FBD id[108]*)
  _TMP_DIV110_OUT := DIV(_TMP_INT_TO_REAL108_OUT, 2.0);(*FBD id[110]*)
  _TMP_MUL100_OUT := MUL(_TMP_SIN99_OUT, _TMP_DIV110_OUT);(*FBD id[100]*)
  _TMP_ADD101_OUT := ADD(_TMP_MUL100_OUT, _TMP_DIV110_OUT);(*FBD id[101]*)
  OUT_SIN := _TMP_ADD101_OUT;(*FBD id[104]*)
END_FUNCTION_BLOCK

FUNCTION_BLOCK Gen_PILA
  VAR_INPUT
    Amplitude : INT;
    Speed : TIME;
  END_VAR
  VAR_OUTPUT
    OUT_INT : INT;
    OUT_REAL : REAL;
  END_VAR
  VAR
    Start : BOOL;
    Stop : BOOL;
    TON_0 : TON;
    TON_1 : TON;
    R_TRIG_0 : R_TRIG;
    Amp : INT;
    R_TRIG_1 : R_TRIG;
    RS_0 : RS;
    R_TRIG_2 : R_TRIG;
    Direct : BOOL;
    R_TRIG_3 : R_TRIG;
    _TMP_LIMIT85_OUT : INT;
    _TMP_LE95_OUT : BOOL;
    _TMP_EQ124_OUT : BOOL;
    _TMP_OR125_OUT : BOOL;
    _TMP_GE122_OUT : BOOL;
    _TMP_EQ130_OUT : BOOL;
    _TMP_OR128_OUT : BOOL;
    _TMP_AND96_OUT : BOOL;
    _TMP_ADD58_ENO : BOOL;
    _TMP_ADD58_OUT : INT;
    _TMP_AND100_OUT : BOOL;
    _TMP_SUB109_ENO : BOOL;
    _TMP_SUB109_OUT : INT;
    _TMP_INT_TO_REAL110_OUT : REAL;
  END_VAR

  _TMP_LIMIT85_OUT := LIMIT(0, Amplitude, 32767);(*FBD id[85]*)
  Amp := _TMP_LIMIT85_OUT;(*FBD id[88]*)
  TON_0(IN := NOT(Stop), PT := Speed);(*FBD id[91]*)
  Start := TON_0.Q;(*FBD id[11]*)
  TON_1(IN := Start, PT := Speed);(*FBD id[92]*)
  Stop := TON_1.Q;(*FBD id[22]*)
  _TMP_LE95_OUT := LE(OUT_INT, Amp);(*FBD id[95]*)
  R_TRIG_2(CLK := _TMP_LE95_OUT);(*FBD id[114]*)
  _TMP_EQ124_OUT := EQ(OUT_INT, 0);(*FBD id[124]*)
  _TMP_OR125_OUT := OR(R_TRIG_2.Q, _TMP_EQ124_OUT);(*FBD id[125]*)
  _TMP_GE122_OUT := GE(OUT_INT, 0);(*FBD id[122]*)
  R_TRIG_3(CLK := _TMP_GE122_OUT);(*FBD id[121]*)
  _TMP_EQ130_OUT := EQ(OUT_INT, Amp);(*FBD id[130]*)
  _TMP_OR128_OUT := OR(R_TRIG_3.Q, _TMP_EQ130_OUT);(*FBD id[128]*)
  RS_0(S := _TMP_OR125_OUT, R1 := _TMP_OR128_OUT);(*FBD id[113]*)
  Direct := RS_0.Q1;(*FBD id[115]*)
  R_TRIG_0(CLK := Start);(*FBD id[94]*)
  _TMP_AND96_OUT := AND(Direct, R_TRIG_0.Q);(*FBD id[96]*)
  IF _TMP_AND96_OUT THEN
      _TMP_ADD58_OUT := ADD(IN1 := OUT_INT, IN2 := 1, ENO => _TMP_ADD58_ENO);(*FBD id[58]*)
  ELSE
    _TMP_ADD58_ENO := FALSE;
  END_IF;
  IF _TMP_ADD58_ENO THEN
      OUT_INT := _TMP_ADD58_OUT;(*FBD id[139]*)
  END_IF;
  R_TRIG_1(CLK := Start);(*FBD id[108]*)
  _TMP_AND100_OUT := AND(NOT(Direct), R_TRIG_1.Q);(*FBD id[100]*)
  IF _TMP_AND100_OUT THEN
      _TMP_SUB109_OUT := SUB(IN1 := OUT_INT, IN2 := 1, ENO => _TMP_SUB109_ENO);(*FBD id[109]*)
  ELSE
    _TMP_SUB109_ENO := FALSE;
  END_IF;
  IF _TMP_SUB109_ENO THEN
      OUT_INT := _TMP_SUB109_OUT;(*FBD id[140]*)
  END_IF;
  _TMP_INT_TO_REAL110_OUT := INT_TO_REAL(OUT_INT);(*FBD id[110]*)
  OUT_REAL := _TMP_INT_TO_REAL110_OUT;(*FBD id[142]*)
END_FUNCTION_BLOCK

PROGRAM DEMO_Generators
  VAR
    Gen_SIN_0 : Gen_SIN;
    Gen_PILA_0 : Gen_PILA;
    Gen_CYCLIC_0 : Gen_Cyclic;
  END_VAR

  Gen_SIN_0(Amplitude := 100);(*FBD id[7]*)
  Gen_PILA_0(Amplitude := 100, Speed := t#100ms);(*FBD id[31]*)
  Gen_CYCLIC_0(Amplitude := 100, Speed := t#100ms);(*FBD id[33]*)
END_PROGRAM

FUNCTION_BLOCK COM_STV900
  VAR_INPUT
    RD1 : WORD;
    RD2 : WORD;
    RD3 : WORD;
    RD4 : WORD;
    RD5 : WORD;
    RD6 : WORD;
    RD7 : WORD;
    RD8 : WORD;
    RD9 : WORD;
    RD10 : WORD;
    RD11 : WORD;
    CMD_CTRL : INT;
    CMD_SET_FREQ : REAL;
  END_VAR
  VAR_OUTPUT
    RUN_FREQ : REAL;
    SET_FREQ : REAL;
    BUS_VOLT : REAL;
    OUTPUT_VOLT : INT;
    OUTPUT_CUR : REAL;
    RUN_SPEED : INT;
    OUTPUT_PWR : REAL;
    OUTPUT_TORQ : REAL;
    SW1 : INT;
    SW2 : WORD;
    FAULT_CODE : INT;
    WR1 : WORD;
    WR2 : WORD;
  END_VAR
  VAR
    _TMP_WORD_TO_REAL1_OUT : REAL;
    _TMP_DIV3_OUT : REAL;
    _TMP_WORD_TO_REAL10_OUT : REAL;
    _TMP_DIV7_OUT : REAL;
    _TMP_WORD_TO_REAL16_OUT : REAL;
    _TMP_DIV13_OUT : REAL;
    _TMP_WORD_TO_INT42_OUT : INT;
    _TMP_WORD_TO_REAL35_OUT : REAL;
    _TMP_DIV23_OUT : REAL;
    _TMP_WORD_TO_INT41_OUT : INT;
    _TMP_WORD_TO_REAL45_OUT : REAL;
    _TMP_DIV46_OUT : REAL;
    _TMP_WORD_TO_REAL55_OUT : REAL;
    _TMP_DIV53_OUT : REAL;
    _TMP_WORD_TO_INT60_OUT : INT;
    _TMP_WORD_TO_INT66_OUT : INT;
    _TMP_INT_TO_WORD73_OUT : WORD;
    _TMP_MUL77_OUT : REAL;
    _TMP_REAL_TO_WORD79_OUT : WORD;
  END_VAR

  _TMP_WORD_TO_REAL1_OUT := WORD_TO_REAL(RD1);(*FBD id[1]*)
  _TMP_DIV3_OUT := DIV(_TMP_WORD_TO_REAL1_OUT, 100.0);(*FBD id[3]*)
  RUN_FREQ := _TMP_DIV3_OUT;(*FBD id[5]*)
  _TMP_WORD_TO_REAL10_OUT := WORD_TO_REAL(RD2);(*FBD id[10]*)
  _TMP_DIV7_OUT := DIV(_TMP_WORD_TO_REAL10_OUT, 100.0);(*FBD id[7]*)
  SET_FREQ := _TMP_DIV7_OUT;(*FBD id[8]*)
  _TMP_WORD_TO_REAL16_OUT := WORD_TO_REAL(RD3);(*FBD id[16]*)
  _TMP_DIV13_OUT := DIV(_TMP_WORD_TO_REAL16_OUT, 10.0);(*FBD id[13]*)
  BUS_VOLT := _TMP_DIV13_OUT;(*FBD id[19]*)
  _TMP_WORD_TO_INT42_OUT := WORD_TO_INT(RD4);(*FBD id[42]*)
  OUTPUT_VOLT := _TMP_WORD_TO_INT42_OUT;(*FBD id[71]*)
  _TMP_WORD_TO_REAL35_OUT := WORD_TO_REAL(RD5);(*FBD id[35]*)
  _TMP_DIV23_OUT := DIV(_TMP_WORD_TO_REAL35_OUT, 10.0);(*FBD id[23]*)
  OUTPUT_CUR := _TMP_DIV23_OUT;(*FBD id[39]*)
  _TMP_WORD_TO_INT41_OUT := WORD_TO_INT(RD6);(*FBD id[41]*)
  RUN_SPEED := _TMP_WORD_TO_INT41_OUT;(*FBD id[40]*)
  _TMP_WORD_TO_REAL45_OUT := WORD_TO_REAL(RD7);(*FBD id[45]*)
  _TMP_DIV46_OUT := DIV(_TMP_WORD_TO_REAL45_OUT, 10.0);(*FBD id[46]*)
  OUTPUT_PWR := _TMP_DIV46_OUT;(*FBD id[49]*)
  _TMP_WORD_TO_REAL55_OUT := WORD_TO_REAL(RD8);(*FBD id[55]*)
  _TMP_DIV53_OUT := DIV(_TMP_WORD_TO_REAL55_OUT, 10.0);(*FBD id[53]*)
  OUTPUT_TORQ := _TMP_DIV53_OUT;(*FBD id[56]*)
  _TMP_WORD_TO_INT60_OUT := WORD_TO_INT(RD9);(*FBD id[60]*)
  SW1 := _TMP_WORD_TO_INT60_OUT;(*FBD id[61]*)
  SW2 := RD10;(*FBD id[65]*)
  _TMP_WORD_TO_INT66_OUT := WORD_TO_INT(RD11);(*FBD id[66]*)
  FAULT_CODE := _TMP_WORD_TO_INT66_OUT;(*FBD id[70]*)
  _TMP_INT_TO_WORD73_OUT := INT_TO_WORD(CMD_CTRL);(*FBD id[73]*)
  WR1 := _TMP_INT_TO_WORD73_OUT;(*FBD id[74]*)
  _TMP_MUL77_OUT := MUL(CMD_SET_FREQ, 100.0);(*FBD id[77]*)
  _TMP_REAL_TO_WORD79_OUT := REAL_TO_WORD(_TMP_MUL77_OUT);(*FBD id[79]*)
  WR2 := _TMP_REAL_TO_WORD79_OUT;(*FBD id[75]*)
END_FUNCTION_BLOCK

PROGRAM DEMO_STV900
  VAR
    COM_STV900_0 : COM_STV900;
  END_VAR

  COM_STV900_0(RD1 := RD1, RD2 := RD2, RD3 := RD3, RD4 := RD4, RD5 := RD5, RD6 := RD6, RD7 := RD7, RD8 := RD8, RD9 := RD9, RD10 := RD10, RD11 := RD11, CMD_CTRL := HMI_CMD_CTRL, CMD_SET_FREQ := HMI_CMD_SET_FREQ);(*FBD id[15]*)
  HMI_RUN_FREQ := COM_STV900_0.RUN_FREQ;(*FBD id[24]*)
  HMI_SET_FREQ := COM_STV900_0.SET_FREQ;(*FBD id[25]*)
  HMI_BUS_VOLT := COM_STV900_0.BUS_VOLT;(*FBD id[26]*)
  HMI_OUTPUT_VOLT := COM_STV900_0.OUTPUT_VOLT;(*FBD id[27]*)
  HMI_OUTPUT_CUR := COM_STV900_0.OUTPUT_CUR;(*FBD id[28]*)
  HMI_RUN_SPEED := COM_STV900_0.RUN_SPEED;(*FBD id[29]*)
  HMI_OUTPUT_PWR := COM_STV900_0.OUTPUT_PWR;(*FBD id[30]*)
  HMI_OUTPUT_TORQ := COM_STV900_0.OUTPUT_TORQ;(*FBD id[31]*)
  HMI_SW1 := COM_STV900_0.SW1;(*FBD id[32]*)
  HMI_SW2 := COM_STV900_0.SW2;(*FBD id[33]*)
  HMI_FAULT_CODE := COM_STV900_0.FAULT_CODE;(*FBD id[34]*)
  WR1 := COM_STV900_0.WR1;(*FBD id[13]*)
  WR2 := COM_STV900_0.WR2;(*FBD id[14]*)
  HMI_STV_COUNTER := missCntModbusRtuNode0;(*FBD id[38]*)
  HMI_STV_ONLINE := missModbusRtuNode0;(*FBD id[36]*)
END_PROGRAM


CONFIGURATION Config0

  RESOURCE Res0 ON PLC
    VAR_GLOBAL
      lastErrorCode AT %MW1.15 : UINT;
    END_VAR
    VAR_GLOBAL
      ExpModDisconHistory AT %MB1.22 : BYTE;
    END_VAR
    VAR_GLOBAL
      missModbusRtuNode0 AT %MX7.1 : BOOL;
      missCntModbusRtuNode0 AT %MW7.1 : UINT;
      switchModbusRtuNode0 AT %MX10.0 : BOOL := 1;
    END_VAR
    VAR_GLOBAL
      DI1 AT %IX0.0 : BOOL := 0;
      DI2 AT %IX0.1 : BOOL := 0;
      DI3 AT %IX0.2 : BOOL := 0;
      DI4 AT %IX0.3 : BOOL := 0;
      DI5 AT %IX0.4 : BOOL := 0;
      DI6 AT %IX0.5 : BOOL := 0;
      DI7 AT %IX0.6 : BOOL := 0;
      DI8 AT %IX0.7 : BOOL := 0;
      AI1 AT %IW1.0 : INT := 0;
      AI2 AT %IW1.1 : INT := 0;
      AI3 AT %IW1.2 : INT := 0;
      AI4 AT %IW1.3 : INT := 0;
      AI5 AT %IW1.4 : INT := 0;
      AI6 AT %IW1.5 : INT := 0;
      AI7 AT %IW1.6 : INT := 0;
      AI8 AT %IW1.7 : INT := 0;
      DO1 AT %QX0.0 : BOOL := 0;
      DO2 AT %QX0.1 : BOOL := 0;
      DO3 AT %QX0.2 : BOOL := 0;
      DO4 AT %QX0.3 : BOOL := 0;
      DO5 AT %QX0.4 : BOOL := 0;
      DO6 AT %QX0.5 : BOOL := 0;
      DO7 AT %QX0.6 : BOOL := 0;
      DO8 AT %QX0.7 : BOOL := 0;
      AO1 AT %QW1.0 : INT := 0;
      AO2 AT %QW1.1 : INT := 0;
      AO3 AT %QW1.2 : INT := 0;
      AO4 AT %QW1.3 : INT := 0;
      FDI1_counter AT %MD5.0 : UDINT := 0;
      FDI1_frequency AT %MD16.0 : UDINT := 0;
      FDI1_reset_counter AT %MX6.0 : BOOL := 0;
      FDI2_counter AT %MD5.1 : UDINT := 0;
      FDI2_frequency AT %MD16.1 : UDINT := 0;
      FDI2_reset_counter AT %MX6.1 : BOOL := 0;
      FDI3_counter AT %MD5.2 : UDINT := 0;
      FDI3_frequency AT %MD16.2 : UDINT := 0;
      FDI3_reset_counter AT %MX6.2 : BOOL := 0;
      FDI4_counter AT %MD5.3 : UDINT := 0;
      FDI4_frequency AT %MD16.3 : UDINT := 0;
      FDI4_reset_counter AT %MX6.3 : BOOL := 0;
      KEY1 AT %MX2.4 : BOOL := 0;
      KEY2 AT %MX2.5 : BOOL := 0;
      KEY3 AT %MX2.6 : BOOL := 0;
      KEY4 AT %MX2.7 : BOOL := 0;
    END_VAR
    VAR_GLOBAL
      HMI_RUN_FREQ AT %QD11.1 : REAL;
      HMI_SET_FREQ AT %QD11.2 : REAL;
      HMI_BUS_VOLT AT %QD11.3 : REAL;
      HMI_OUTPUT_CUR AT %QD11.4 : REAL;
      HMI_OUTPUT_PWR AT %QD11.5 : REAL;
      HMI_OUTPUT_TORQ AT %QD11.6 : REAL;
      HMI_CMD_SET_FREQ AT %QD11.7 : REAL := 25.0;
      HMI_RUN_SPEED AT %QW11.16 : INT;
      HMI_OUTPUT_VOLT AT %QW11.17 : INT;
      HMI_SW1 AT %QW11.18 : INT;
      HMI_SW2 AT %QW11.19 : WORD;
      HMI_FAULT_CODE AT %QW11.20 : INT;
      HMI_CMD_CTRL AT %QW11.21 : INT := 5;
      HMI_STV_COUNTER AT %QW11.22 : UINT;
      HMI_STV_ONLINE AT %QX10.0 : BOOL;
      RD1 AT %IW11.0 : WORD;
      RD2 AT %IW11.1 : WORD;
      RD3 AT %IW11.2 : WORD;
      RD4 AT %IW11.3 : WORD;
      RD5 AT %IW11.4 : WORD;
      RD6 AT %IW11.5 : WORD;
      RD7 AT %IW11.6 : WORD;
      RD8 AT %IW11.7 : WORD;
      RD9 AT %IW11.8 : WORD;
      RD10 AT %IW11.9 : WORD;
      RD11 AT %IW11.10 : WORD;
      WR1 AT %QW11.0 : WORD;
      WR2 AT %QW11.1 : WORD;
    END_VAR
    TASK task0(INTERVAL := T#10ms,PRIORITY := 0);
    PROGRAM instance0 WITH task0 : DEMO_AI_4_20mA;
    PROGRAM instance1 WITH task0 : DEMO_AI_0_20mA;
    PROGRAM instance2 WITH task0 : DEMO_AI_0_10V;
    PROGRAM instance3 WITH task0 : DEMO_AI_PT100;
    PROGRAM instance4 WITH task0 : DEMO_AI_PT1000;
    PROGRAM instance5 WITH task0 : DEMO_AI_RTD;
    PROGRAM instance6 WITH task0 : DEMO_DI_DO;
    PROGRAM instance7 WITH task0 : DEMO_Timer_Counter;
    PROGRAM instance8 WITH task0 : DEMO_STV900;
    PROGRAM instance9 WITH task0 : DEMO_Generators;
    PROGRAM instance10 WITH task0 : DEMO_AO_0_10V;
    PROGRAM instance11 WITH task0 : DEMO_AO_4_20mA;
  END_RESOURCE
END_CONFIGURATION
