/*
 * DEBUGGER code
 * 
 * On "publish", when buffer is free, debugger stores arbitrary variables 
 * content into, and mark this buffer as filled
 * 
 * 
 * Buffer content is read asynchronously, (from non real time part), 
 * and then buffer marked free again.
 *  
 * 
 * */

#include "iec_types_all.h"
#include "POUS.h"
/*for memcpy*/
#include <string.h>
#include <stdio.h>

typedef unsigned int dbgvardsc_index_t;


/***
 * Declare programs 
 **/
extern MAIN RES0__INSTANCE0;

/***
 * Declare global variables from resources and conf 
 **/
extern __IEC_UINT_p RES0__LASTERRORCODE;
extern __IEC_BYTE_p RES0__EXPMODDISCONHISTORY;
extern __IEC_BOOL_p RES0__DI1;
extern __IEC_BOOL_p RES0__DI2;
extern __IEC_BOOL_p RES0__DI3;
extern __IEC_BOOL_p RES0__DI4;
extern __IEC_BOOL_p RES0__DI5;
extern __IEC_BOOL_p RES0__DI6;
extern __IEC_BOOL_p RES0__DI7;
extern __IEC_BOOL_p RES0__DI8;
extern __IEC_INT_p RES0__AI1;
extern __IEC_INT_p RES0__AI2;
extern __IEC_INT_p RES0__AI3;
extern __IEC_INT_p RES0__AI4;
extern __IEC_INT_p RES0__AI5;
extern __IEC_INT_p RES0__AI6;
extern __IEC_INT_p RES0__AI7;
extern __IEC_INT_p RES0__AI8;
extern __IEC_BOOL_p RES0__DO1;
extern __IEC_BOOL_p RES0__DO2;
extern __IEC_BOOL_p RES0__DO3;
extern __IEC_BOOL_p RES0__DO4;
extern __IEC_BOOL_p RES0__DO5;
extern __IEC_BOOL_p RES0__DO6;
extern __IEC_BOOL_p RES0__DO7;
extern __IEC_BOOL_p RES0__DO8;
extern __IEC_INT_p RES0__AO1;
extern __IEC_INT_p RES0__AO2;
extern __IEC_INT_p RES0__AO3;
extern __IEC_INT_p RES0__AO4;
extern __IEC_UDINT_p RES0__FDI1_COUNTER;
extern __IEC_UDINT_p RES0__FDI1_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI1_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI2_COUNTER;
extern __IEC_UDINT_p RES0__FDI2_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI2_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI3_COUNTER;
extern __IEC_UDINT_p RES0__FDI3_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI3_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI4_COUNTER;
extern __IEC_UDINT_p RES0__FDI4_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI4_RESET_COUNTER;
extern __IEC_BOOL_p RES0__FDO1_ENABLE;
extern __IEC_UINT_p RES0__FDO1_FREQUENCY;
extern __IEC_UINT_p RES0__FDO1_DUTYFACTOR;
extern __IEC_BOOL_p RES0__FDO2_ENABLE;
extern __IEC_UINT_p RES0__FDO2_FREQUENCY;
extern __IEC_UINT_p RES0__FDO2_DUTYFACTOR;
extern __IEC_BOOL_p RES0__KEY1;
extern __IEC_BOOL_p RES0__KEY2;
extern __IEC_BOOL_p RES0__KEY3;
extern __IEC_BOOL_p RES0__KEY4;
extern       MAIN   RES0__INSTANCE0;

typedef const struct {
    void *ptr;
    __IEC_types_enum type;
} dbgvardsc_t;

const dbgvardsc_t dbgvardsc[] = {
{&(RES0__LASTERRORCODE), UINT_O_ENUM},
{&(RES0__EXPMODDISCONHISTORY), BYTE_O_ENUM},
{&(RES0__DI1), BOOL_P_ENUM},
{&(RES0__DI2), BOOL_P_ENUM},
{&(RES0__DI3), BOOL_P_ENUM},
{&(RES0__DI4), BOOL_P_ENUM},
{&(RES0__DI5), BOOL_P_ENUM},
{&(RES0__DI6), BOOL_P_ENUM},
{&(RES0__DI7), BOOL_P_ENUM},
{&(RES0__DI8), BOOL_P_ENUM},
{&(RES0__AI1), INT_P_ENUM},
{&(RES0__AI2), INT_P_ENUM},
{&(RES0__AI3), INT_P_ENUM},
{&(RES0__AI4), INT_P_ENUM},
{&(RES0__AI5), INT_P_ENUM},
{&(RES0__AI6), INT_P_ENUM},
{&(RES0__AI7), INT_P_ENUM},
{&(RES0__AI8), INT_P_ENUM},
{&(RES0__DO1), BOOL_O_ENUM},
{&(RES0__DO2), BOOL_O_ENUM},
{&(RES0__DO3), BOOL_O_ENUM},
{&(RES0__DO4), BOOL_O_ENUM},
{&(RES0__DO5), BOOL_O_ENUM},
{&(RES0__DO6), BOOL_O_ENUM},
{&(RES0__DO7), BOOL_O_ENUM},
{&(RES0__DO8), BOOL_O_ENUM},
{&(RES0__AO1), INT_O_ENUM},
{&(RES0__AO2), INT_O_ENUM},
{&(RES0__AO3), INT_O_ENUM},
{&(RES0__AO4), INT_O_ENUM},
{&(RES0__FDI1_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI1_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI1_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI2_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI2_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI2_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI3_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI3_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI3_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI4_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI4_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI4_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDO1_ENABLE), BOOL_O_ENUM},
{&(RES0__FDO1_FREQUENCY), UINT_O_ENUM},
{&(RES0__FDO1_DUTYFACTOR), UINT_O_ENUM},
{&(RES0__FDO2_ENABLE), BOOL_O_ENUM},
{&(RES0__FDO2_FREQUENCY), UINT_O_ENUM},
{&(RES0__FDO2_DUTYFACTOR), UINT_O_ENUM},
{&(RES0__KEY1), BOOL_O_ENUM},
{&(RES0__KEY2), BOOL_O_ENUM},
{&(RES0__KEY3), BOOL_O_ENUM},
{&(RES0__KEY4), BOOL_O_ENUM},
{&(RES0__INSTANCE0.DI_GETRTC_OUT), DINT_ENUM},
{&(RES0__INSTANCE0.UI_GETRTC_YEAR), UINT_ENUM},
{&(RES0__INSTANCE0.UI_GETRTC_MONTH), UINT_ENUM},
{&(RES0__INSTANCE0.UI_GETRTC_DAYMONTH), UINT_ENUM},
{&(RES0__INSTANCE0.UI_GETRTC_DAYWEEK), UINT_ENUM},
{&(RES0__INSTANCE0.UI_GETRTC_HOURS), UINT_ENUM},
{&(RES0__INSTANCE0.UI_GETRTC_MINUTES), UINT_ENUM},
{&(RES0__INSTANCE0.UI_GETRTC_SECONDS), UINT_ENUM},
{&(RES0__INSTANCE0.UI_SETRTC_YEAR), UINT_ENUM},
{&(RES0__INSTANCE0.UI_SETRTC_MONTH), UINT_ENUM},
{&(RES0__INSTANCE0.UI_SETRTC_DEYMONTH), UINT_ENUM},
{&(RES0__INSTANCE0.UI_SETRTC_HOURS), UINT_ENUM},
{&(RES0__INSTANCE0.UI_SETRTC_MINUTES), UINT_ENUM},
{&(RES0__INSTANCE0.UI_SETRTC_SECONDS), UINT_ENUM},
{&(RES0__INSTANCE0.UI_SETRTC_OUT), DINT_ENUM},
{&(RES0__INSTANCE0.XSETRTC), BOOL_ENUM},
{&(RES0__INSTANCE0.R_0.EN), BOOL_ENUM},
{&(RES0__INSTANCE0.R_0.ENO), BOOL_ENUM},
{&(RES0__INSTANCE0.R_0.CLK), BOOL_ENUM},
{&(RES0__INSTANCE0.R_0.Q), BOOL_ENUM},
{&(RES0__INSTANCE0.R_0.M), BOOL_ENUM},
{&(RES0__INSTANCE0._TMP_GET_RTC1_OUT), DINT_ENUM},
{&(RES0__INSTANCE0._TMP_GET_RTC1_YEAR), UINT_ENUM},
{&(RES0__INSTANCE0._TMP_GET_RTC1_MONTH), UINT_ENUM},
{&(RES0__INSTANCE0._TMP_GET_RTC1_DAYMONTH), UINT_ENUM},
{&(RES0__INSTANCE0._TMP_GET_RTC1_DAYWEEK), UINT_ENUM},
{&(RES0__INSTANCE0._TMP_GET_RTC1_HOURS), UINT_ENUM},
{&(RES0__INSTANCE0._TMP_GET_RTC1_MINUTES), UINT_ENUM},
{&(RES0__INSTANCE0._TMP_GET_RTC1_SECONDS), UINT_ENUM},
{&(RES0__INSTANCE0._TMP_SET_RTC2_ENO), BOOL_ENUM},
{&(RES0__INSTANCE0._TMP_SET_RTC2_OUT), DINT_ENUM}
};
const unsigned int dbgvardsc_size = sizeof(dbgvardsc)/sizeof(dbgvardsc_t);

const dbgvardsc_index_t retain_list[] = {

};
const unsigned int retain_list_size = sizeof(retain_list)/sizeof(dbgvardsc_index_t);



void __init_debug(void)
{

}