/*
 * DEBUGGER code
 * 
 * On "publish", when buffer is free, debugger stores arbitrary variables 
 * content into, and mark this buffer as filled
 * 
 * 
 * Buffer content is read asynchronously, (from non real time part), 
 * and then buffer marked free again.
 *  
 * 
 * */

#include "iec_types_all.h"
#include "POUS.h"
/*for memcpy*/
#include <string.h>
#include <stdio.h>

typedef unsigned int dbgvardsc_index_t;


/***
 * Declare programs 
 **/
extern MAIN RES0__INSTANCE0;

/***
 * Declare global variables from resources and conf 
 **/
extern __IEC_UINT_p RES0__LASTERRORCODE;
extern __IEC_BYTE_p RES0__EXPMODDISCONHISTORY;
extern __IEC_BOOL_p RES0__DI1;
extern __IEC_BOOL_p RES0__DI2;
extern __IEC_BOOL_p RES0__DI3;
extern __IEC_BOOL_p RES0__DI4;
extern __IEC_BOOL_p RES0__DI5;
extern __IEC_BOOL_p RES0__DI6;
extern __IEC_BOOL_p RES0__DI7;
extern __IEC_BOOL_p RES0__DI8;
extern __IEC_INT_p RES0__AI1;
extern __IEC_INT_p RES0__AI2;
extern __IEC_INT_p RES0__AI3;
extern __IEC_INT_p RES0__AI4;
extern __IEC_INT_p RES0__AI5;
extern __IEC_INT_p RES0__AI6;
extern __IEC_INT_p RES0__AI7;
extern __IEC_INT_p RES0__AI8;
extern __IEC_BOOL_p RES0__DO1;
extern __IEC_BOOL_p RES0__DO2;
extern __IEC_BOOL_p RES0__DO3;
extern __IEC_BOOL_p RES0__DO4;
extern __IEC_BOOL_p RES0__DO5;
extern __IEC_BOOL_p RES0__DO6;
extern __IEC_BOOL_p RES0__DO7;
extern __IEC_BOOL_p RES0__DO8;
extern __IEC_INT_p RES0__AO1;
extern __IEC_INT_p RES0__AO2;
extern __IEC_INT_p RES0__AO3;
extern __IEC_INT_p RES0__AO4;
extern __IEC_UDINT_p RES0__FDI1_COUNTER;
extern __IEC_UDINT_p RES0__FDI1_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI1_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI2_COUNTER;
extern __IEC_UDINT_p RES0__FDI2_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI2_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI3_COUNTER;
extern __IEC_UDINT_p RES0__FDI3_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI3_RESET_COUNTER;
extern __IEC_UDINT_p RES0__FDI4_COUNTER;
extern __IEC_UDINT_p RES0__FDI4_FREQUENCY;
extern __IEC_BOOL_p RES0__FDI4_RESET_COUNTER;
extern __IEC_BOOL_p RES0__KEY1;
extern __IEC_BOOL_p RES0__KEY2;
extern __IEC_BOOL_p RES0__KEY3;
extern __IEC_BOOL_p RES0__KEY4;
extern __IEC_BOOL_p RES0__AL_ALARM1;
extern __IEC_BOOL_p RES0__AL_ALARM2;
extern __IEC_BOOL_p RES0__AL_ALARM3;
extern __IEC_BOOL_p RES0__AL_ALARM4;
extern __IEC_BOOL_p RES0__AL_ALARM5;
extern __IEC_BOOL_p RES0__AL_ALARM6;
extern __IEC_BOOL_p RES0__AL_ALARM7;
extern __IEC_BOOL_p RES0__AL_ALARM8;
extern __IEC_BOOL_p RES0__AL_ALARM9;
extern __IEC_BOOL_p RES0__AL_ALARM10;
extern       MAIN   RES0__INSTANCE0;

typedef const struct {
    void *ptr;
    __IEC_types_enum type;
} dbgvardsc_t;

const dbgvardsc_t dbgvardsc[] = {
{&(RES0__LASTERRORCODE), UINT_O_ENUM},
{&(RES0__EXPMODDISCONHISTORY), BYTE_O_ENUM},
{&(RES0__DI1), BOOL_P_ENUM},
{&(RES0__DI2), BOOL_P_ENUM},
{&(RES0__DI3), BOOL_P_ENUM},
{&(RES0__DI4), BOOL_P_ENUM},
{&(RES0__DI5), BOOL_P_ENUM},
{&(RES0__DI6), BOOL_P_ENUM},
{&(RES0__DI7), BOOL_P_ENUM},
{&(RES0__DI8), BOOL_P_ENUM},
{&(RES0__AI1), INT_P_ENUM},
{&(RES0__AI2), INT_P_ENUM},
{&(RES0__AI3), INT_P_ENUM},
{&(RES0__AI4), INT_P_ENUM},
{&(RES0__AI5), INT_P_ENUM},
{&(RES0__AI6), INT_P_ENUM},
{&(RES0__AI7), INT_P_ENUM},
{&(RES0__AI8), INT_P_ENUM},
{&(RES0__DO1), BOOL_O_ENUM},
{&(RES0__DO2), BOOL_O_ENUM},
{&(RES0__DO3), BOOL_O_ENUM},
{&(RES0__DO4), BOOL_O_ENUM},
{&(RES0__DO5), BOOL_O_ENUM},
{&(RES0__DO6), BOOL_O_ENUM},
{&(RES0__DO7), BOOL_O_ENUM},
{&(RES0__DO8), BOOL_O_ENUM},
{&(RES0__AO1), INT_O_ENUM},
{&(RES0__AO2), INT_O_ENUM},
{&(RES0__AO3), INT_O_ENUM},
{&(RES0__AO4), INT_O_ENUM},
{&(RES0__FDI1_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI1_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI1_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI2_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI2_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI2_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI3_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI3_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI3_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__FDI4_COUNTER), UDINT_O_ENUM},
{&(RES0__FDI4_FREQUENCY), UDINT_O_ENUM},
{&(RES0__FDI4_RESET_COUNTER), BOOL_O_ENUM},
{&(RES0__KEY1), BOOL_O_ENUM},
{&(RES0__KEY2), BOOL_O_ENUM},
{&(RES0__KEY3), BOOL_O_ENUM},
{&(RES0__KEY4), BOOL_O_ENUM},
{&(RES0__AL_ALARM1), BOOL_O_ENUM},
{&(RES0__AL_ALARM2), BOOL_O_ENUM},
{&(RES0__AL_ALARM3), BOOL_O_ENUM},
{&(RES0__AL_ALARM4), BOOL_O_ENUM},
{&(RES0__AL_ALARM5), BOOL_O_ENUM},
{&(RES0__AL_ALARM6), BOOL_O_ENUM},
{&(RES0__AL_ALARM7), BOOL_O_ENUM},
{&(RES0__AL_ALARM8), BOOL_O_ENUM},
{&(RES0__AL_ALARM9), BOOL_O_ENUM},
{&(RES0__AL_ALARM10), BOOL_O_ENUM}
};
const unsigned int dbgvardsc_size = sizeof(dbgvardsc)/sizeof(dbgvardsc_t);

const dbgvardsc_index_t retain_list[] = {

};
const unsigned int retain_list_size = sizeof(retain_list)/sizeof(dbgvardsc_index_t);



void __init_debug(void)
{

}